/*
 * Decompiled with CFR 0.152.
 */
package org.openejb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

public class FileUtils {
    private static final Random _random = new Random();
    private static FileUtils openejbHomeUtils = new FileUtils("openejb.home", "user.dir");
    private static FileUtils openejbBaseUtils = new FileUtils("openejb.base", "openejb.home");
    private File home;

    private FileUtils(String homeDir, String defaultDir) {
        String homePath = null;
        try {
            homePath = System.getProperty(homeDir);
            if (homePath == null) {
                homePath = System.getProperty(defaultDir);
                System.setProperty(homeDir, homePath);
            }
            this.home = new File(homePath);
            if (!this.home.exists() || this.home.exists() && !this.home.isDirectory()) {
                homePath = System.getProperty("user.dir");
                System.setProperty(homeDir, homePath);
                this.home = new File(homePath);
            }
            this.home = this.home.getAbsoluteFile();
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    public static FileUtils getBase() {
        return openejbBaseUtils;
    }

    public static FileUtils getHome() {
        return openejbHomeUtils;
    }

    public File getDirectory(String path) throws IOException {
        File dir;
        block5: {
            dir = null;
            dir = new File(this.home, path);
            if (!(dir = dir.getCanonicalFile()).exists()) {
                try {
                    if (!dir.mkdirs()) {
                        throw new IOException("Cannot create the directory " + dir.getPath());
                    }
                    break block5;
                }
                catch (SecurityException e) {
                    throw new IOException("Permission denied: Cannot create the directory " + dir.getPath() + " : " + e.getMessage());
                }
            }
            if (dir.exists() && !dir.isDirectory()) {
                throw new IOException("The path specified is not a valid directory: " + dir.getPath());
            }
        }
        return dir;
    }

    public File getFile(String path) throws FileNotFoundException, IOException {
        return this.getFile(path, true);
    }

    public File getFile(String path, boolean validate) throws FileNotFoundException, IOException {
        File file = null;
        file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(this.home, path);
        }
        if (validate && !file.exists()) {
            throw new FileNotFoundException("The path specified is not a valid file: " + file.getPath());
        }
        if (validate && file.isDirectory()) {
            throw new FileNotFoundException("The path specified is a directory, not a file: " + file.getPath());
        }
        return file;
    }

    public static File createTempDirectory(String pathPrefix) throws IOException {
        int maxAttempts = 100;
        while (maxAttempts > 0) {
            String path = pathPrefix + _random.nextLong();
            File tmpDir = new File(path);
            if (!tmpDir.exists()) {
                tmpDir.mkdir();
                return tmpDir;
            }
            --maxAttempts;
        }
        throw new IOException("Can't create temporary directory.");
    }

    public static File createTempDirectory() throws IOException {
        String prefix = System.getProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "openejb";
        return FileUtils.createTempDirectory(prefix);
    }

    /*
     * WARNING - void declaration
     */
    public static void copyFile(File to, File from) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int aByte;
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            while ((aByte = in.read()) != -1) {
                void var4_4;
                out.write((int)var4_4);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            in.close();
            out.close();
            throw throwable;
        }
        in.close();
        out.close();
    }
}

