/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.administration.rmi;

import java.rmi.Naming;
import java.util.Vector;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.administration.AdminConnection;
import org.exolab.jms.administration.JmsAdminServerIfc;
import org.exolab.jms.server.rmi.RemoteJmsAdminConnectionIfc;
import org.exolab.jms.server.rmi.RemoteJmsAdminServerIfc;
import org.exolab.jms.util.UUID;

public class RmiJmsAdminConnection
implements JmsAdminServerIfc,
AdminConnection {
    private RemoteJmsAdminServerIfc _delegate = null;
    private RemoteJmsAdminConnectionIfc _admin = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$administration$rmi$RmiJmsAdminConnection == null ? (class$org$exolab$jms$administration$rmi$RmiJmsAdminConnection = RmiJmsAdminConnection.class$("org.exolab.jms.administration.rmi.RmiJmsAdminConnection")) : class$org$exolab$jms$administration$rmi$RmiJmsAdminConnection));
    private String _serverAddress;
    private String _name;
    private int _port;
    private String _clientId = null;
    static /* synthetic */ Class class$org$exolab$jms$administration$rmi$RmiJmsAdminConnection;

    public RmiJmsAdminConnection(String host, int port, String name, String username, String password) throws JMSException {
        this._serverAddress = host;
        this._port = port;
        this._name = name;
        this._clientId = UUID.next();
        this.connect(this._clientId, username, password);
    }

    public boolean addDurableConsumer(String topic, String name) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.addDurableConsumer(topic, name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean removeDurableConsumer(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.removeDurableConsumer(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean durableConsumerExists(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.durableConsumerExists(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public Vector getDurableConsumers(String topic) throws JMSException {
        Vector result = null;
        try {
            result = this._admin.getDurableConsumers(topic);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean unregisterConsumer(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.unregisterConsumer(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean isConnected(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.isConnected(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean addDestination(String destination, Boolean queue) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.addDestination(destination, queue);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean removeDestination(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.removeDestination(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean destinationExists(String name) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.destinationExists(name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public Vector getAllDestinations() throws JMSException {
        Vector result = null;
        try {
            result = this._admin.getAllDestinations();
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public int getDurableConsumerMessageCount(String topic, String name) throws JMSException {
        int result = 0;
        try {
            result = this._admin.getDurableConsumerMessageCount(topic, name);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public int getQueueMessageCount(String queue) throws JMSException {
        int result = 0;
        try {
            result = this._admin.getQueueMessageCount(queue);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public int purgeMessages() throws JMSException {
        int result = 0;
        try {
            result = this._admin.purgeMessages();
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public void stopServer() throws JMSException {
        try {
            this._admin.stopServer();
        }
        catch (Exception exception) {
            this.raise(exception);
        }
    }

    public void close() {
        this._admin = null;
    }

    protected void openConnection() throws JMSException {
        try {
            if (this._name == null) {
                this._name = "JmsAdminServer";
            }
            String url = "//" + this._serverAddress + ":" + this._port + "/" + this._name;
            this._delegate = (RemoteJmsAdminServerIfc)Naming.lookup(url);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
    }

    private void connect(String clientId, String username, String password) throws JMSException {
        this.openConnection();
        try {
            this._admin = this.getDelegate().createConnection(clientId, username, password);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
    }

    private void raise(Exception exception) throws JMSException {
        if (exception instanceof JMSException) {
            throw (JMSException)exception;
        }
        JMSException error = new JMSException(exception.getMessage());
        error.setLinkedException(exception);
        throw error;
    }

    public boolean addUser(String username, String password) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.addUser(username, password);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public Vector getAllUsers() throws JMSException {
        Vector result = null;
        try {
            result = this._admin.getAllUsers();
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean removeUser(String username) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.removeUser(username);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public boolean changePassword(String username, String password) throws JMSException {
        boolean result = false;
        try {
            result = this._admin.changePassword(username, password);
        }
        catch (Exception exception) {
            this.raise(exception);
        }
        return result;
    }

    public RemoteJmsAdminServerIfc getDelegate() {
        return this._delegate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

