/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.util.Date;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsSession;
import org.exolab.jms.client.JmsTemporaryDestination;
import org.exolab.jms.message.MessageId;

abstract class JmsMessageProducer
implements MessageProducer {
    private int _defaultPriority = 4;
    private long _defaultTtl = 0L;
    private int _deliveryMode = 2;
    private boolean _disableTimestamp = false;
    private boolean _disableMessageId = false;
    private JmsSession _session = null;

    public JmsMessageProducer(JmsSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 'session' is null");
        }
        this._session = session;
    }

    public void setDisableMessageID(boolean value) {
        this._disableMessageId = value;
    }

    public boolean getDisableMessageID() {
        return this._disableMessageId;
    }

    public void setDisableMessageTimestamp(boolean value) {
        this._disableTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() {
        return this._disableTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) {
        this._deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() {
        return this._deliveryMode;
    }

    public void setPriority(int priority) {
        this._defaultPriority = priority;
    }

    public int getPriority() {
        return this._defaultPriority;
    }

    public void setTimeToLive(long timeToLive) {
        this._defaultTtl = timeToLive;
    }

    public long getTimeToLive() {
        return this._defaultTtl;
    }

    public synchronized void close() throws JMSException {
        this._session = null;
    }

    public synchronized void destroy() {
        this._session = null;
    }

    public synchronized boolean isClosed() {
        return this._session != null;
    }

    protected JmsSession getSession() {
        return this._session;
    }

    protected void sendMessage(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (!(destination instanceof JmsDestination)) {
            throw new InvalidDestinationException("Invalid destination: " + destination);
        }
        if (message == null) {
            throw new MessageFormatException("Null message");
        }
        message.setJMSMessageID(MessageId.create());
        message.setJMSDestination(destination);
        message.setJMSTimestamp(new Date().getTime());
        message.setJMSPriority(priority);
        if (timeToLive > 0L) {
            message.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        } else {
            message.setJMSExpiration(0L);
        }
        if (destination instanceof JmsTemporaryDestination) {
            message.setJMSDeliveryMode(1);
        } else {
            message.setJMSDeliveryMode(deliveryMode);
        }
        this._session.sendMessage(message);
    }
}

