/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;
import javax.naming.Reference;
import javax.naming.Referenceable;
import org.exolab.jms.client.JmsConnection;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsTemporaryDestination;
import org.exolab.jms.util.UUID;

public class JmsTemporaryQueue
extends JmsQueue
implements TemporaryQueue,
JmsTemporaryDestination,
Externalizable,
Referenceable {
    static final long serialVersionUID = 1L;
    private String _connectionId = null;
    private transient JmsConnection _connection = null;

    public JmsTemporaryQueue() {
        super("tempqueue:" + UUID.next());
    }

    public void delete() throws JMSException {
        this._connection.deleteTemporaryDestination(this);
    }

    public void setOwningConnection(JmsConnection connection) {
        this._connection = connection;
        this._connectionId = connection.getConnectionId();
    }

    public JmsConnection getOwningConnection() {
        return this._connection;
    }

    public String getConnectionId() {
        return this._connectionId;
    }

    public Reference getReference() {
        return null;
    }

    public boolean validForConnection(JmsConnection connection) {
        boolean result = false;
        if (connection != null && connection.getConnectionId().equals(this._connectionId)) {
            result = true;
        }
        return result;
    }

    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(1L);
        stream.writeObject(this._connectionId);
        super.writeExternal(stream);
    }

    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 1L) {
            throw new IOException("JmsTemporaryQueue with version " + version + " is not supported.");
        }
        this._connectionId = (String)stream.readObject();
        super.readExternal(stream);
    }
}

