/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.util.HashSet;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.exolab.jms.client.JmsDestination;
import org.exolab.jms.client.JmsSession;
import org.exolab.jms.client.JmsTemporaryTopic;
import org.exolab.jms.client.JmsTopic;
import org.exolab.jms.client.JmsTopicConnection;
import org.exolab.jms.client.JmsTopicPublisher;
import org.exolab.jms.client.JmsTopicSubscriber;

class JmsTopicSession
extends JmsSession
implements TopicSession {
    private HashSet _durableNames = new HashSet();

    public JmsTopicSession(JmsTopicConnection connection, boolean transacted, int ackMode) throws JMSException {
        super(connection, transacted, ackMode);
    }

    public synchronized Topic createTopic(String topicName) throws JMSException {
        this.ensureOpen();
        JmsTopic topic = null;
        if (topicName == null || topicName.length() <= 0) {
            throw new JMSException("Invalid or null topic name specified");
        }
        topic = new JmsTopic(topicName);
        return topic;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.createSubscriber(topic, null, false);
    }

    public synchronized TopicSubscriber createSubscriber(Topic topic, String selector, boolean noLocal) throws JMSException {
        JmsTopicSubscriber subscriber = null;
        this.ensureOpen();
        if (topic == null) {
            throw new InvalidDestinationException("Cannot create subscriber: argument 'topic' is null");
        }
        if (!this.checkForValidTemporaryDestination((JmsDestination)topic)) {
            throw new InvalidDestinationException("Trying to create a subscriber for a temp topic that is not bound to this connection");
        }
        subscriber = new JmsTopicSubscriber(this, this.getNextConsumerId(), (JmsTopic)topic, selector, noLocal, null);
        this.addSubscriber(subscriber, null);
        return subscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return this.createDurableSubscriber(topic, name, null, false);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        JmsTopicSubscriber subscriber = null;
        this.ensureOpen();
        if (topic == null) {
            throw new InvalidDestinationException("Cannot create durable subscriber: argument 'topic' is null");
        }
        if (name == null || name.trim().length() == 0) {
            throw new JMSException("Invalid subscription name specified");
        }
        if (this._durableNames.contains(name)) {
            throw new JMSException("A durable subscriber already exists with name=" + name);
        }
        if (((JmsTopic)topic).isTemporaryDestination()) {
            throw new InvalidDestinationException("Cannot create a durable subscriber for a temporary topic");
        }
        JmsTopic durable = null;
        try {
            durable = (JmsTopic)((JmsTopic)topic).clone();
        }
        catch (CloneNotSupportedException error) {
            throw new JMSException("Failed to clone JmsTopic");
        }
        durable.setPersistent(true);
        subscriber = new JmsTopicSubscriber(this, this.getNextConsumerId(), durable, selector, noLocal, name);
        this.addSubscriber(subscriber, name);
        this._durableNames.add(name);
        return subscriber;
    }

    public synchronized TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.ensureOpen();
        if (topic != null && ((JmsTopic)topic).isWildCard()) {
            throw new JMSException("Cannot create a publisher using a wildcard topic");
        }
        JmsTopicPublisher publisher = new JmsTopicPublisher(this, (JmsTopic)topic);
        this.addPublisher(publisher);
        return publisher;
    }

    public synchronized TemporaryTopic createTemporaryTopic() throws JMSException {
        this.ensureOpen();
        JmsTemporaryTopic topic = new JmsTemporaryTopic();
        topic.setOwningConnection(this.getConnection());
        return topic;
    }

    public synchronized void unsubscribe(String name) throws JMSException {
        this.ensureOpen();
        if (name != null && name.length() > 0) {
            if (this._durableNames.contains(name)) {
                throw new JMSException("Cannot unsubscribe while an active TopicSubscriber exists");
            }
        } else {
            throw new JMSException("Cannot unsubscribe with a null name");
        }
        this.getJmsSessionStub().unsubscribe(name);
        this._durableNames.remove(name);
    }

    protected synchronized void addSubscriber(JmsTopicSubscriber subscriber, String name) throws JMSException {
        this.getJmsSessionStub().createSubscriber((JmsTopic)subscriber.getTopic(), name, subscriber.getClientId(), subscriber.getMessageSelector(), subscriber.getNoLocal());
        this.addConsumer(subscriber);
    }

    protected synchronized void addPublisher(JmsTopicPublisher publisher) throws JMSException {
        this.getJmsSessionStub().createPublisher((JmsTopic)publisher.getTopic());
        this.addProducer(publisher);
    }

    protected synchronized void removeSubscriber(JmsTopicSubscriber subscriber) throws JMSException {
        if (!this.isClosed()) {
            this.removeMessageListener(subscriber);
            this.getJmsSessionStub().deleteSubscriber(subscriber.getClientId());
        }
        this.removeConsumer(subscriber);
        if (subscriber.isDurableSubscriber()) {
            this._durableNames.remove(subscriber.getName());
        }
    }

    protected synchronized void removePublisher(JmsTopicPublisher publisher) {
        this.removeProducer(publisher);
    }
}

