/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.http;

import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.exolab.core.http.HttpClient;
import org.exolab.core.ipc.IpcIfc;
import org.exolab.jms.client.JmsConnectionStubIfc;
import org.exolab.jms.client.JmsServerStubIfc;
import org.exolab.jms.client.http.HttpJmsConnectionStub;

public class HttpJmsServerStub
implements JmsServerStubIfc {
    private String _url;
    private String _label = "HttpJmsServerStub";
    private ExceptionListener _listener = null;

    public HttpJmsServerStub() {
    }

    public HttpJmsServerStub(Hashtable env) throws JMSException {
        this._url = (String)env.get("org.exolab.jms.http.server.url");
        if (this._url == null) {
            throw new JMSException("Required property not specified: org.exolab.jms.http.server.url");
        }
    }

    public HttpJmsServerStub(String url) {
        this._url = url;
    }

    public JmsConnectionStubIfc createConnection(String clientId, String username, String password) throws JMSException {
        HttpJmsConnectionStub stub = null;
        try {
            Vector v = this.pack("createConnection", clientId, username, password);
            HttpClient connection = new HttpClient(this._url, this._label);
            connection.send((Serializable)v);
            String connectionId = (String)this.checkReply(connection, "createConnection");
            stub = new HttpJmsConnectionStub((IpcIfc)connection, clientId, connectionId);
        }
        catch (IOException exception) {
            throw new JMSException("Failed to create connection, URL=" + this._url + ": " + exception);
        }
        return stub;
    }

    public void setExceptionListener(ExceptionListener listener) {
        this._listener = listener;
    }

    protected void setURL(String URL2) {
        this._url = URL2;
    }

    protected void setLabel(String label) {
        this._label = label;
    }

    protected Object checkReply(HttpClient connection, String method) throws JMSException {
        Object result = null;
        Vector v = null;
        try {
            v = (Vector)connection.receive();
        }
        catch (Exception err) {
            throw new JMSException("Operation " + method + " failed: " + err);
        }
        if (v != null) {
            Boolean b = (Boolean)v.get(0);
            if (!b.booleanValue()) {
                if (v.get(1) instanceof JMSException) {
                    throw (JMSException)((Object)v.get(1));
                }
                throw new JMSException("Operation " + method + " failed:\n" + v.get(1));
            }
        } else {
            throw new JMSException("Unknown connection error for " + method);
        }
        result = v.get(1);
        return result;
    }

    protected Vector pack(String method, String id, String username, String password) {
        Vector<String> v = new Vector<String>(5);
        v.add("org.exolab.jms.server.mipc.IpcJmsServerConnection");
        v.add(method);
        v.add(id);
        v.add(username);
        v.add(password);
        return v;
    }
}

