/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.http.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.core.ipc.Client;

public class HttpJmsClientServlet
extends HttpServlet {
    private HashMap _connections = new HashMap();
    private static final String CONTENT_TYPE = "text/html";

    public void init() {
        this.log("OpenJMS client servlet ready");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectInputStream input = new ObjectInputStream(new BufferedInputStream((InputStream)request.getInputStream()));
        ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream((OutputStream)response.getOutputStream()));
        response.setContentType(CONTENT_TYPE);
        String host = request.getHeader("jms-host");
        int port = request.getIntHeader("jms-port");
        try {
            try {
                Object object = input.readObject();
                if (object instanceof Vector) {
                    Client connection;
                    Vector message = (Vector)object;
                    Client client = connection = this.getConnection(host, port);
                    synchronized (client) {
                        connection.send((Serializable)message);
                        String type = request.getHeader("jms-response");
                        if (type != null && type.equals("yes")) {
                            message = (Vector)connection.receive();
                            output.writeObject(message);
                        }
                    }
                    response.setStatus(200);
                }
                if (object instanceof String && "close".equals(object)) {
                    this.removeConnection(host, port);
                }
                this.log("Received invalid request");
                response.setStatus(415);
                output.writeObject("Object is NULL, or UNEXPECTED type");
            }
            catch (Exception exception) {
                this.log("Failed to process request", exception);
                this.removeConnection(host, port);
                response.setStatus(500);
                output.writeObject(exception.getMessage());
                Object var14_14 = null;
                output.flush();
                return;
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            output.flush();
            throw throwable;
        }
        output.flush();
    }

    public synchronized void destroy() {
        Iterator iterator = this._connections.values().iterator();
        while (iterator.hasNext()) {
            Client client = (Client)iterator.next();
            try {
                client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private synchronized Client getConnection(String host, int port) throws IOException {
        String key = host + ":" + port;
        Client client = (Client)this._connections.get(key);
        if (client == null) {
            try {
                client = new Client(host, port);
            }
            catch (IOException exception) {
                throw new IOException("Failed to connect to host=" + host + ", port=" + port + ": " + exception.getMessage());
            }
            this._connections.put(key, client);
        }
        return client;
    }

    private synchronized void removeConnection(String host, int port) {
        String key = host + ":" + port;
        Client client = (Client)this._connections.remove(key);
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }
}

