/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.mipc;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.ipc.IpcIfc;
import org.exolab.core.mipc.DisconnectionEventListener;
import org.exolab.core.mipc.MultiplexConnection;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.core.mipc.ObjectChannel;
import org.exolab.jms.client.JmsConnectionStubIfc;
import org.exolab.jms.client.JmsServerStubIfc;
import org.exolab.jms.client.mipc.IpcJmsConnectionStub;
import org.exolab.jms.client.mipc.IpcJmsMessageListener;

public class IpcJmsServerStub
implements JmsServerStubIfc,
DisconnectionEventListener {
    private MultiplexConnectionIfc _mc = null;
    private IpcIfc _connection = null;
    private String _serverAddress = "127.0.0.1";
    private String _internalServerAddress = null;
    private int _port = 3030;
    private HashSet _connections = new HashSet();
    private IpcJmsMessageListener _listener;
    private ExceptionListener _exceptionListener = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$mipc$IpcJmsServerStub == null ? (class$org$exolab$jms$client$mipc$IpcJmsServerStub = IpcJmsServerStub.class$("org.exolab.jms.client.mipc.IpcJmsServerStub")) : class$org$exolab$jms$client$mipc$IpcJmsServerStub));
    static /* synthetic */ Class class$org$exolab$jms$client$mipc$IpcJmsServerStub;

    public IpcJmsServerStub() {
    }

    public IpcJmsServerStub(Hashtable env) {
        if (env.containsKey("org.exolab.jms.mipc.server.host")) {
            this._serverAddress = (String)env.get("org.exolab.jms.mipc.server.host");
        }
        if (env.containsKey("org.exolab.jms.mipc.server.internal.host")) {
            this._internalServerAddress = (String)env.get("org.exolab.jms.mipc.server.internal.host");
        }
        if (env.containsKey("org.exolab.jms.mipc.server.port")) {
            try {
                this._port = Integer.parseInt((String)env.get("org.exolab.jms.mipc.server.port"));
            }
            catch (NumberFormatException exception) {
                _log.warn((Object)("Server port is not a valid format. Defaulting to " + this._port));
            }
        }
    }

    public IpcJmsServerStub(String host, int port) {
        if (host != null && host.length() > 0) {
            this._serverAddress = host;
        }
        this._port = port;
    }

    public synchronized JmsConnectionStubIfc createConnection(String clientId, String username, String password) throws JMSException {
        IpcJmsConnectionStub stub = null;
        this.openConnection();
        try {
            String connectionId;
            Vector v = this.pack("createConnection", clientId, username, password);
            IpcIfc ipcIfc = this._connection;
            synchronized (ipcIfc) {
                this._connection.send((Serializable)v);
                connectionId = (String)this.checkReply("createConnection");
            }
            stub = new IpcJmsConnectionStub(this, this._connection, clientId, connectionId, this._listener);
            this._connections.add(stub);
        }
        catch (JMSException exception) {
            throw exception;
        }
        catch (Exception exception) {
            JMSException error = new JMSException("Failed to create connection");
            error.setLinkedException(exception);
            throw error;
        }
        return stub;
    }

    public void setServerAddress(String host) {
        this._serverAddress = host;
    }

    public String getServerAddress() {
        return this._serverAddress;
    }

    public void setServerPort(int port) {
        this._port = port;
    }

    public int getServerPort() {
        return this._port;
    }

    public void disconnected(MultiplexConnectionIfc connection) {
        this.close();
        if (this._exceptionListener != null) {
            JMSException exception = new JMSException("Connection to server terminated", "connection_to_server_dropped");
            this._exceptionListener.onException(exception);
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        this._exceptionListener = listener;
    }

    public synchronized void close() {
        try {
            block4: {
                try {
                    if (this._connection == null) break block4;
                    this._connection.close();
                    this._listener.stop();
                    this._mc.finish();
                }
                catch (Exception exception) {
                    Object var3_2 = null;
                    this._mc = null;
                    this._connection = null;
                    this._listener = null;
                }
            }
            Object var3_1 = null;
            this._mc = null;
            this._connection = null;
            this._listener = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._mc = null;
            this._connection = null;
            this._listener = null;
            throw throwable;
        }
    }

    public synchronized void closed(IpcJmsConnectionStub connection) {
        this._connections.remove(connection);
        if (this._connections.isEmpty()) {
            this.close();
        }
    }

    protected MultiplexConnectionIfc createClientConnection(String serverAddress, String internalServerAddress, int port) throws Exception {
        MultiplexConnection result = null;
        try {
            result = new MultiplexConnection(serverAddress, port);
        }
        catch (IOException exception) {
            if (internalServerAddress != null) {
                result = new MultiplexConnection(internalServerAddress, port);
            }
            throw exception;
        }
        return result;
    }

    private synchronized void openConnection() throws JMSException {
        if (this._mc == null) {
            try {
                this._mc = this.createClientConnection(this._serverAddress, this._internalServerAddress, this._port);
            }
            catch (Exception exception) {
                throw new JMSException("Failed to create connection: " + exception);
            }
            this._mc.setDisconnectionEventListener((DisconnectionEventListener)this);
            ((Thread)this._mc).start();
            this._connection = new ObjectChannel("server", this._mc);
            this._listener = new IpcJmsMessageListener(this._mc);
        }
    }

    private Object checkReply(String method) throws JMSException {
        Object result = null;
        Vector v = null;
        try {
            v = (Vector)this._connection.receive();
        }
        catch (Exception err) {
            throw new JMSException("Operation " + method + " failed: " + err);
        }
        if (v != null) {
            Boolean b = (Boolean)v.get(0);
            if (!b.booleanValue()) {
                if (v.get(1) instanceof JMSException) {
                    throw (JMSException)((Object)v.get(1));
                }
                throw new JMSException("Operation " + method + " failed:\n" + v.get(1));
            }
        } else {
            throw new JMSException("Unknown connection error for " + method);
        }
        result = v.get(1);
        return result;
    }

    private Vector pack(String method, String id, String username, String password) {
        Vector<String> v = new Vector<String>(5);
        v.add("org.exolab.jms.server.mipc.IpcJmsServerConnection");
        v.add(method);
        v.add(id);
        v.add(username);
        v.add(password);
        return v;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

