/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.config;

import java.io.File;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationFileException;
import org.exolab.jms.config.ConfigurationLoader;
import org.exolab.jms.config.Connector;
import org.exolab.jms.config.FileDoesNotExistException;
import org.exolab.jms.config.types.SchemeType;

public class ConfigurationManager {
    private static Configuration _config = null;

    public static synchronized void setConfig(String path) throws FileDoesNotExistException, ConfigurationFileException {
        File config = new File(path);
        if (config.exists()) {
            ConfigurationLoader loader = new ConfigurationLoader();
            try {
                _config = loader.load(path);
            }
            catch (Exception exception) {
                throw new ConfigurationFileException("Error occured in " + path + " " + exception);
            }
        } else {
            throw new FileDoesNotExistException("Configuration file " + path + " does not exist.");
        }
    }

    public static synchronized void setConfig(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("Argument 'config' is null");
        }
        _config = config;
    }

    public static synchronized Configuration getConfig() {
        if (_config == null) {
            throw new IllegalStateException("Configuration manager has not been initialised");
        }
        return _config;
    }

    public static Connector getConnector(SchemeType scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Argument scheme is null");
        }
        Connector result = null;
        Configuration config = ConfigurationManager.getConfig();
        Connector[] connectors = config.getConnectors().getConnector();
        int i = 0;
        while (i < connectors.length) {
            if (connectors[i].getScheme().equals(scheme)) {
                result = connectors[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public static Connector getConnector() {
        Configuration config = ConfigurationManager.getConfig();
        return config.getConnectors().getConnector(0);
    }
}

