/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.service.BasicService;
import org.exolab.core.service.ServiceException;
import org.exolab.core.service.ServiceState;
import org.exolab.core.threadPool.ThreadPool;
import org.exolab.core.util.OrderedQueue;
import org.exolab.jms.events.Event;
import org.exolab.jms.events.EventManager;
import org.exolab.jms.events.IllegalEventDefinedException;
import org.exolab.jms.threads.ThreadPoolExistsException;
import org.exolab.jms.threads.ThreadPoolManager;

public class BasicEventManager
extends BasicService
implements EventManager {
    public static final transient String NAME = "EventManager";
    public static final transient int MAX_THREADS = 5;
    private HashMap _events = new HashMap();
    private transient ThreadPool _pool;
    private transient Object _queueSync = new Object();
    private transient OrderedQueue _queue = new OrderedQueue(_queueComparator);
    private transient long _seed;
    private static final transient String EVENT_MANAGER_THREAD_NAME = "EventManagerThread";
    private static transient EventManager _instance = null;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$events$BasicEventManager == null ? (class$org$exolab$jms$events$BasicEventManager = BasicEventManager.class$("org.exolab.jms.events.BasicEventManager")) : class$org$exolab$jms$events$BasicEventManager));
    private static final transient Comparator _queueComparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            QueueEntry qe1 = (QueueEntry)obj1;
            QueueEntry qe2 = (QueueEntry)obj2;
            if (qe1.absolute < qe2.absolute) {
                return -1;
            }
            if (qe1.absolute > qe2.absolute) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object that) {
            return this == that;
        }
    };
    static /* synthetic */ Class class$org$exolab$jms$events$BasicEventManager;

    public static EventManager instance() {
        if (_instance == null) {
            _instance = new BasicEventManager();
        }
        return _instance;
    }

    protected BasicEventManager() {
        super(EVENT_MANAGER_THREAD_NAME);
    }

    public String registerEvent(Event event, long absolute) throws IllegalEventDefinedException {
        Object object = this._queueSync;
        synchronized (object) {
            QueueEntry entry = new QueueEntry(event, absolute, this.generateId());
            this._queue.add((Object)entry);
            this._events.put(entry.id, entry);
            this._queueSync.notifyAll();
            String string = entry.id;
            return string;
        }
    }

    public String registerEventRelative(Event event, long relative) throws IllegalEventDefinedException {
        return this.registerEvent(event, System.currentTimeMillis() + relative);
    }

    public void unregisterEvent(String id) {
        Object object = this._queueSync;
        synchronized (object) {
            Object obj = this._events.remove(id);
            if (obj == null) {
                return;
            }
            this._queue.remove(obj);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Object object = this._queueSync;
        synchronized (object) {
            while (this.getState() != ServiceState.STOPPED) {
                QueueEntry entry;
                long currentTime = System.currentTimeMillis();
                try {
                    entry = (QueueEntry)this._queue.firstElement();
                }
                catch (NoSuchElementException ex) {
                    try {
                        this._queueSync.wait();
                        continue;
                    }
                    catch (InterruptedException ex1) {
                        break;
                    }
                }
                if (entry.absolute <= currentTime) {
                    try {
                        this.getThreadPool().execute((Runnable)entry);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    this._queue.removeFirstElement();
                    this._events.remove(entry.id);
                    continue;
                }
                try {
                    this._queueSync.wait(entry.absolute - currentTime);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            return;
        }
    }

    private synchronized String generateId() {
        return Long.toString(++this._seed);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = this._queueSync;
        synchronized (object) {
            in.defaultReadObject();
            Iterator itt = this._events.values().iterator();
            while (itt.hasNext()) {
                this._queue.add(itt.next());
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Object object = this._queueSync;
        synchronized (object) {
            out.defaultWriteObject();
        }
    }

    public void start() throws ServiceException {
        super.start();
    }

    private ThreadPool getThreadPool() {
        if (this._pool == null) {
            try {
                this._pool = ThreadPoolManager.instance().createThreadPool(NAME, 5);
            }
            catch (ThreadPoolExistsException err) {
                _log.error((Object)"Thread pool EventManager already exists");
            }
        }
        return this._pool;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class QueueEntry
    implements Serializable,
    Runnable {
        private long absolute;
        private Event event;
        private String id;

        QueueEntry(Event event, long absolute, String id) {
            this.absolute = absolute;
            this.event = event;
            this.id = id;
        }

        public void run() {
            this.event.getEventListener().handleEvent(this.event.getEventType(), this.event.getCallbackObject(), System.currentTimeMillis());
        }
    }
}

