/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndi.rmi;

import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import org.apache.avalon.excalibur.naming.DefaultNamespace;
import org.apache.avalon.excalibur.naming.NamingProvider;
import org.apache.avalon.excalibur.naming.RemoteContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.util.URI;

public class RmiJndiInitialContextFactory
implements InitialContextFactory {
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$jndi$rmi$RmiJndiInitialContextFactory == null ? (class$org$exolab$jms$jndi$rmi$RmiJndiInitialContextFactory = RmiJndiInitialContextFactory.class$("org.exolab.jms.jndi.rmi.RmiJndiInitialContextFactory")) : class$org$exolab$jms$jndi$rmi$RmiJndiInitialContextFactory));
    static /* synthetic */ Class class$org$exolab$jms$jndi$rmi$RmiJndiInitialContextFactory;

    public Context getInitialContext(Hashtable environment) throws NamingException {
        NameParser parser;
        NamingProvider provider;
        Object result = null;
        if (environment == null) {
            throw new ConfigurationException("Cannot connect to JNDI provider - environment not set");
        }
        String url = (String)environment.get("java.naming.provider.url");
        if (url != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URI.MalformedURIException exception) {
                throw new ConfigurationException("Malformed JNDI provider URL: " + url);
            }
            String path = uri.getPath();
            if (path == null || path.length() == 0) {
                url = url + "/JndiServer";
            } else if (path.equals("/")) {
                url = url + "JndiServer";
            }
        } else {
            url = this.getDeprecatedEnvironment(environment);
        }
        try {
            provider = (NamingProvider)((Object)Naming.lookup(url));
        }
        catch (MalformedURLException exception) {
            throw new ConfigurationException("Malformed JNDI provider URL: " + url);
        }
        catch (NotBoundException exception) {
            throw new ServiceUnavailableException("JNDI service is not bound in the registry for URL: " + url);
        }
        catch (RemoteException exception) {
            CommunicationException error = new CommunicationException("Failed to lookup JNDI provider for URL: " + url);
            error.setRootCause(exception);
            throw error;
        }
        try {
            parser = provider.getNameParser();
        }
        catch (NamingException exception) {
            throw exception;
        }
        catch (Exception exception) {
            ServiceUnavailableException error = new ServiceUnavailableException(exception.getMessage());
            error.setRootCause(exception);
            throw error;
        }
        DefaultNamespace namespace = new DefaultNamespace(parser);
        Hashtable<String, Object> env = new Hashtable<String, Object>(environment);
        env.put("org.apache.avalon.excalibur.naming.NamingProvider", provider);
        env.put("org.apache.avalon.excalibur.naming.Namespace", namespace);
        return new RemoteContext(env, parser.parse(""));
    }

    private String getDeprecatedEnvironment(Hashtable environment) {
        _log.warn((Object)(this.getClass().getName() + ": using deprecated environment. Use Context.PROVIDER_URL"));
        StringBuffer url = new StringBuffer("rmi://");
        String host = (String)environment.get("org.exolab.jms.jndi.host");
        Integer port = (Integer)environment.get("org.exolab.jms.jndi.port");
        String name = (String)environment.get("org.exolab.jms.jndi.name");
        if (host != null) {
            url.append(host);
            url.append(":");
        } else {
            url.append("localhost:");
        }
        if (port != null) {
            url.append(port.toString());
            url.append("/");
        } else {
            url.append("1099/");
        }
        if (name != null) {
            url.append(name);
        } else {
            url.append("JndiServer");
        }
        return url.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

