/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.JMSException;
import org.exolab.jms.message.MessageId;

class CorrelationId
implements Externalizable {
    static final long serialVersionUID = 1L;
    static final int APPLICATION_USE = 1;
    static final int PROVIDER_USE = 2;
    static final int PROVIDER_NATIVE = 3;
    private int _usage = 0;
    private MessageId _id = null;
    private String _clientId = null;

    public CorrelationId() {
    }

    public CorrelationId(String id) throws JMSException {
        if (id.startsWith("ID:")) {
            this._usage = 2;
            this._id = new MessageId(id);
        } else {
            this._usage = 1;
            this._clientId = id;
        }
    }

    public CorrelationId(byte[] id) throws JMSException {
        throw new UnsupportedOperationException("Provider native correlation identifier not supported");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(1L);
        out.writeInt(this._usage);
        if (this._usage == 1) {
            out.writeInt(this._clientId.length());
            out.writeChars(this._clientId);
        } else if (this._usage == 2) {
            this._id.writeExternal(out);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version == 1L) {
            this._usage = in.readInt();
            if (this._usage == 1) {
                int len = in.readInt();
                StringBuffer buf = new StringBuffer(len);
                int i = 0;
                while (i < len) {
                    buf.append(in.readChar());
                    ++i;
                }
                this._clientId = buf.toString();
            } else if (this._usage == 2) {
                this._id = new MessageId();
                this._id.readExternal(in);
            }
        } else {
            throw new IOException("Incorrect version enountered: " + version + ". This version = " + 1L);
        }
    }

    public String getString() throws JMSException {
        String result = null;
        if (this._usage == 1) {
            result = this._clientId;
        } else if (this._usage == 2) {
            result = this._id.toString();
        } else {
            throw new JMSException("Unknown correlation");
        }
        return result;
    }

    public byte[] getBytes() throws JMSException {
        throw new UnsupportedOperationException("Provider native correlation identifier not supported");
    }
}

