/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exolab.jms.Identifiable;
import org.exolab.jms.util.UUID;

public final class MessageId
implements Externalizable,
Identifiable {
    static final long serialVersionUID = 2L;
    private String _id = null;
    public static final String PREFIX = "ID:";
    private static final String NULL_ID = "ID:0";

    public MessageId() {
    }

    public MessageId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(2L);
        out.writeUTF(this._id);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version == 2L) {
            this._id = in.readUTF();
        } else if (version == 1L) {
            long oldID = in.readLong();
            String id = (String)in.readObject();
            this._id = PREFIX + id;
        } else {
            throw new IOException("Incorrect version enountered: " + version + " This version = " + 2L);
        }
    }

    public String toString() {
        return this._id;
    }

    public boolean equals(Object object) {
        boolean equal;
        boolean bl = equal = object == this;
        if (!equal && object instanceof MessageId && ((MessageId)object)._id.equals(this._id)) {
            equal = true;
        }
        return equal;
    }

    public static String create() {
        return UUID.next(PREFIX);
    }

    public static String getNull() {
        return NULL_ID;
    }
}

