/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.exolab.jms.Identifiable;
import org.exolab.jms.message.MessageHeader;
import org.exolab.jms.message.MessageId;
import org.exolab.jms.message.MessageProperties;
import org.exolab.jms.message.MessageSessionIfc;

public class MessageImpl
implements Message,
Externalizable,
Cloneable,
Identifiable {
    static final long serialVersionUID = 1L;
    private MessageSessionIfc _session = null;
    private MessageHeader _messageHeader = new MessageHeader();
    private MessageProperties _messageProperties = new MessageProperties();
    protected boolean _propertiesReadOnly = false;
    protected boolean _bodyReadOnly = false;
    protected long _acceptedTime;
    protected long _sequenceNumber;
    protected transient int _connectionId;
    protected boolean _processed = false;
    protected static final byte[] EMPTY = new byte[0];

    public Object clone() throws CloneNotSupportedException {
        MessageImpl result = (MessageImpl)super.clone();
        result._messageHeader = (MessageHeader)this._messageHeader.clone();
        result._messageProperties = (MessageProperties)this._messageProperties.clone();
        return result;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(1L);
        out.writeBoolean(this._propertiesReadOnly || this._bodyReadOnly);
        out.writeBoolean(this._processed);
        out.writeLong(this._acceptedTime);
        out.writeLong(this._sequenceNumber);
        out.writeObject(this._messageHeader);
        out.writeObject(this._messageProperties);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean readOnly;
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Incorrect version enountered: " + version + ". This version = " + 1L);
        }
        this._propertiesReadOnly = readOnly = in.readBoolean();
        this._bodyReadOnly = readOnly;
        this._processed = in.readBoolean();
        this._acceptedTime = in.readLong();
        this._sequenceNumber = in.readLong();
        this._messageHeader = (MessageHeader)in.readObject();
        this._messageProperties = (MessageProperties)in.readObject();
    }

    public void setSession(MessageSessionIfc session) {
        this._session = session;
        MessageId id = this._messageHeader.getMessageId();
        if (id != null) {
            this._messageHeader.setAckMessageID(id.getId());
        }
    }

    public String getJMSMessageID() throws JMSException {
        return this._messageHeader.getJMSMessageID();
    }

    public void setJMSMessageID(String id) throws JMSException {
        this._messageHeader.setJMSMessageID(id);
    }

    public String getAckMessageID() {
        return this._messageHeader.getAckMessageID();
    }

    public long getJMSTimestamp() throws JMSException {
        return this._messageHeader.getJMSTimestamp();
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this._messageHeader.setJMSTimestamp(timestamp);
    }

    public String getWildcard() {
        return this._messageHeader.getWildcard();
    }

    public MessageId getMessageId() {
        return this._messageHeader.getMessageId();
    }

    public void setWildcard(String wildcard) {
        this._messageHeader.setWildcard(wildcard);
    }

    public String getConsumerId() {
        return this._messageHeader.getConsumerId();
    }

    public void setConsumerId(String consumerId) {
        this._messageHeader.setConsumerId(consumerId);
    }

    public long getClientId() {
        return this._messageHeader.getClientId();
    }

    public void setClientId(long clientId) {
        this._messageHeader.setClientId(clientId);
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this._messageHeader.getJMSCorrelationIDAsBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this._messageHeader.setJMSCorrelationIDAsBytes(correlationID);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this._messageHeader.setJMSCorrelationID(correlationID);
    }

    public String getJMSCorrelationID() throws JMSException {
        return this._messageHeader.getJMSCorrelationID();
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this._messageHeader.getJMSReplyTo();
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        this._messageHeader.setJMSReplyTo(replyTo);
    }

    public Destination getJMSDestination() throws JMSException {
        return this._messageHeader.getJMSDestination();
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this._messageHeader.setJMSDestination(destination);
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this._messageHeader.getJMSDeliveryMode();
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        this._messageHeader.setJMSDeliveryMode(deliveryMode);
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this._messageHeader.getJMSRedelivered();
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this._messageHeader.setJMSRedelivered(redelivered);
    }

    public String getJMSType() throws JMSException {
        return this._messageHeader.getJMSType();
    }

    public void setJMSType(String type) throws JMSException {
        this._messageHeader.setJMSType(type);
    }

    public long getJMSExpiration() throws JMSException {
        return this._messageHeader.getJMSExpiration();
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this._messageHeader.setJMSExpiration(expiration);
    }

    public int getJMSPriority() throws JMSException {
        return this._messageHeader.getJMSPriority();
    }

    public void setJMSPriority(int priority) throws JMSException {
        this._messageHeader.setJMSPriority(priority);
    }

    public boolean isPersistent() {
        return this._messageHeader.isPersistent();
    }

    public boolean isPriorityExpedited() throws JMSException {
        return this._messageHeader.isPriorityExpedited();
    }

    public void clearProperties() throws JMSException {
        this._messageProperties.clearProperties();
        this._propertiesReadOnly = false;
    }

    public boolean propertyExists(String name) throws JMSException {
        return this._messageProperties.propertyExists(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        return this._messageProperties.getBooleanProperty(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        return this._messageProperties.getByteProperty(name);
    }

    public short getShortProperty(String name) throws JMSException {
        return this._messageProperties.getShortProperty(name);
    }

    public int getIntProperty(String name) throws JMSException {
        return this._messageProperties.getIntProperty(name);
    }

    public long getLongProperty(String name) throws JMSException {
        return this._messageProperties.getLongProperty(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        return this._messageProperties.getFloatProperty(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        return this._messageProperties.getDoubleProperty(name);
    }

    public String getStringProperty(String name) throws JMSException {
        return this._messageProperties.getStringProperty(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this._messageProperties.getObjectProperty(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this._messageProperties.getPropertyNames();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setBooleanProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setByteProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setShortProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setIntProperty(name, value);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setLongProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setFloatProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setDoubleProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setStringProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkPropertyWrite();
        this._messageProperties.setObjectProperty(name, value);
    }

    public void acknowledge() throws JMSException {
        if (this.getAckMessageID() == null) {
            throw new JMSException("Cannot acknowledge message: no identifier");
        }
        if (this._session == null) {
            throw new JMSException("Cannot acknowledge message: unknown session");
        }
        this._session.acknowledgeMessage(this);
    }

    public void clearBody() throws JMSException {
        this._bodyReadOnly = false;
    }

    public final void checkPropertyWrite() throws MessageNotWriteableException {
        if (this._propertiesReadOnly) {
            throw new MessageNotWriteableException("Message in read-only mode");
        }
    }

    public final void checkWrite() throws MessageNotWriteableException {
        if (this._bodyReadOnly) {
            throw new MessageNotWriteableException("Message in read-only mode");
        }
    }

    public final void checkRead() throws MessageNotReadableException {
        if (!this._bodyReadOnly) {
            throw new MessageNotReadableException("Message in write-only mode");
        }
    }

    public String getId() {
        return this._messageHeader.getMessageId().getId();
    }

    public void setAcceptedTime(long time) {
        this._acceptedTime = time;
    }

    public long getAcceptedTime() {
        return this._acceptedTime;
    }

    public void setSequenceNumber(long seq) {
        this._sequenceNumber = seq;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public void setConnectionId(int id) {
        this._connectionId = id;
    }

    public int getConnectionId() {
        return this._connectionId;
    }

    public void setProcessed(boolean state) {
        this._processed = state;
    }

    public boolean getProcessed() {
        return this._processed;
    }

    public void setReadOnly(boolean readOnly) throws JMSException {
        this._propertiesReadOnly = readOnly;
        this._bodyReadOnly = readOnly;
    }

    public final boolean getReadOnly() {
        return this._propertiesReadOnly && this._bodyReadOnly;
    }

    public void setJMSXRcvTimestamp(long timestamp) {
        this._messageProperties.setJMSXRcvTimestamp(timestamp);
    }
}

