/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.http.servlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.core.ipc.IpcIfc;
import org.exolab.core.mipc.DisconnectionEventListener;
import org.exolab.core.mipc.MultiplexConnection;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.core.mipc.ObjectChannel;

public class HttpJmsServerServlet
extends HttpServlet
implements DisconnectionEventListener {
    private static MultiplexConnectionIfc _mc = null;
    private static IpcIfc _connection = null;
    private static String _host = "127.0.0.1";
    private static int _port = 3030;
    private static final String CONTENT_TYPE = "text/html";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (config != null) {
            String host = config.getInitParameter("org.exolab.jms.jndi.host");
            String port = config.getInitParameter("org.exolab.jms.jndi.port");
            if (host != null) {
                _host = host;
            }
            if (port != null) {
                _port = Integer.parseInt(port);
            }
        }
        this.connect();
        this.log("OpenJMS server servlet ready");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ObjectInputStream input = new ObjectInputStream(new BufferedInputStream((InputStream)request.getInputStream()));
        ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream((OutputStream)response.getOutputStream()));
        response.setContentType(CONTENT_TYPE);
        try {
            try {
                Object object;
                if (_mc == null) {
                    this.connect();
                }
                if ((object = input.readObject()) instanceof Vector) {
                    IpcIfc ipcIfc = _connection;
                    synchronized (ipcIfc) {
                        Vector message = (Vector)object;
                        _connection.send((Serializable)message);
                        String type = request.getHeader("jms-response");
                        if (type != null && type.equals("yes")) {
                            message = (Vector)_connection.receive();
                            output.writeObject(message);
                        }
                    }
                    response.setStatus(200);
                }
                response.setStatus(415);
                output.writeObject("Object is NULL, or UNEXPECTED type");
            }
            catch (Exception exception) {
                response.setStatus(500);
                output.writeObject(exception.getMessage());
                Object var11_11 = null;
                output.flush();
                return;
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            output.flush();
            throw throwable;
        }
        output.flush();
    }

    public void destroy() {
        this.disconnected(null);
    }

    public void disconnected(MultiplexConnectionIfc connection) {
        if (_mc != null) {
            try {
                try {
                    _mc.finish();
                    _connection.close();
                }
                catch (Exception ignore) {
                    Object var4_3 = null;
                    _mc = null;
                    _connection = null;
                }
                Object var4_2 = null;
                _mc = null;
                _connection = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                _mc = null;
                _connection = null;
                throw throwable;
            }
        }
    }

    protected void connect() throws ServletException {
        try {
            _mc = new MultiplexConnection(_host, _port);
        }
        catch (Exception exception) {
            String message = "Failed to connect using host=" + _host + " and port=" + _port + " " + exception.getMessage();
            this.log(message);
            throw new ServletException(message);
        }
        _mc.setDisconnectionEventListener((DisconnectionEventListener)this);
        ((Thread)_mc).start();
        _connection = new ObjectChannel("server", _mc);
    }
}

