/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.threads;

import java.util.HashMap;
import org.exolab.core.service.BasicService;
import org.exolab.core.service.ServiceException;
import org.exolab.core.service.ServiceState;
import org.exolab.core.threadPool.ThreadPool;
import org.exolab.jms.threads.ThreadPoolExistsException;
import org.exolab.jms.threads.UnknownThreadPoolException;

public class ThreadPoolManager
extends BasicService {
    private static HashMap _pools = null;
    private static ThreadPoolManager _instance = null;
    private static final String THREADPOOLMGR_NAME = "ThreadPoolManager";

    private ThreadPoolManager() {
        super(THREADPOOLMGR_NAME);
        _pools = new HashMap();
    }

    public static ThreadPoolManager instance() {
        if (_instance == null) {
            _instance = new ThreadPoolManager();
        }
        return _instance;
    }

    public ThreadPool createThreadPool(String name, int size) throws ThreadPoolExistsException {
        HashMap hashMap = _pools;
        synchronized (hashMap) {
            if (_pools.containsKey(name)) {
                throw new ThreadPoolExistsException("ThreadPool with name " + name + " exists");
            }
            ThreadPool pool = new ThreadPool(name, size, true);
            _pools.put(name, pool);
            ThreadPool threadPool = pool;
            return threadPool;
        }
    }

    public ThreadPool getThreadPool(String name) throws UnknownThreadPoolException {
        ThreadPool pool = null;
        HashMap hashMap = _pools;
        synchronized (hashMap) {
            pool = (ThreadPool)_pools.get(name);
        }
        if (pool == null) {
            throw new UnknownThreadPoolException("ThreadPool with name " + name + " does not exist");
        }
        return pool;
    }

    public void deleteThreadPool(String name) throws UnknownThreadPoolException {
        ThreadPool pool = null;
        HashMap hashMap = _pools;
        synchronized (hashMap) {
            pool = (ThreadPool)_pools.remove(name);
        }
        if (pool == null) {
            throw new UnknownThreadPoolException("ThreadPool with name " + name + " does not exist");
        }
        pool.stopRequestAllWorkers();
    }

    public synchronized void run() {
        while (this.getState() != ServiceState.STOPPED) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stop() throws ServiceException {
        HashMap hashMap = _pools;
        synchronized (hashMap) {
            Object[] ob = _pools.values().toArray();
            int i = 0;
            int j = _pools.size();
            while (i < j) {
                ((ThreadPool)ob[i]).stopRequestAllWorkers();
                ++i;
            }
            _pools.clear();
        }
        super.stop();
        _pools = null;
        _instance = null;
    }
}

