/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.util;

import java.util.Hashtable;
import java.util.Vector;

public class CommandLine {
    private Vector _switches = new Vector();
    private Hashtable _options = new Hashtable();

    public CommandLine(String[] args) {
        this.processCommandLine(args);
    }

    public CommandLine() {
    }

    public boolean exists(String name) {
        return this._switches.contains(name) || this._options.containsKey(name);
    }

    public boolean isSwitch(String name) {
        return this._switches.contains(name);
    }

    public boolean isParameter(String name) {
        return this._options.containsKey(name);
    }

    public String value(String name) {
        String result = null;
        if (this._options.containsKey(name)) {
            result = (String)this._options.get(name);
        }
        return result;
    }

    public String value(String name, String defaultValue) {
        String result = this.value(name);
        return result != null ? result : defaultValue;
    }

    public boolean add(String name, String value) {
        return this.add(name, value, true);
    }

    public boolean add(String name, String value, boolean overwrite) {
        boolean result = false;
        if (value == null) {
            if (this._switches.contains(name) && overwrite) {
                this._switches.addElement(name);
                result = true;
            } else if (!this._switches.contains(name)) {
                this._switches.addElement(name);
                result = true;
            }
        } else if (this._options.containsKey(name) && overwrite) {
            this._options.put(name, value);
            result = true;
        } else if (!this._options.containsKey(name)) {
            this._options.put(name, value);
            result = true;
        }
        return result;
    }

    private void processCommandLine(String[] args) {
        boolean prev_was_hyphen = false;
        String prev_key = null;
        int index = 0;
        while (index < args.length) {
            if (args[index].startsWith("-")) {
                if (prev_was_hyphen) {
                    this.add(prev_key, null);
                }
                prev_key = args[index].substring(1);
                prev_was_hyphen = true;
                if (index == args.length - 1) {
                    this.add(prev_key, null);
                    break;
                }
            } else {
                if (prev_key != null) {
                    this.add(prev_key, args[index]);
                    prev_key = null;
                }
                prev_was_hyphen = false;
            }
            ++index;
        }
    }
}

