/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisValidationException;

public final class MultiClusterClientConfig {
    private static final int RETRY_MAX_ATTEMPTS_DEFAULT = 3;
    private static final int RETRY_WAIT_DURATION_DEFAULT = 500;
    private static final int RETRY_WAIT_DURATION_EXPONENTIAL_BACKOFF_MULTIPLIER_DEFAULT = 2;
    private static final Class RETRY_INCLUDED_EXCEPTIONS_DEFAULT = JedisConnectionException.class;
    private static final float CIRCUIT_BREAKER_FAILURE_RATE_THRESHOLD_DEFAULT = 50.0f;
    private static final int CIRCUIT_BREAKER_SLIDING_WINDOW_MIN_CALLS_DEFAULT = 100;
    private static final CircuitBreakerConfig.SlidingWindowType CIRCUIT_BREAKER_SLIDING_WINDOW_TYPE_DEFAULT = CircuitBreakerConfig.SlidingWindowType.COUNT_BASED;
    private static final int CIRCUIT_BREAKER_SLIDING_WINDOW_SIZE_DEFAULT = 100;
    private static final int CIRCUIT_BREAKER_SLOW_CALL_DURATION_THRESHOLD_DEFAULT = 60000;
    private static final float CIRCUIT_BREAKER_SLOW_CALL_RATE_THRESHOLD_DEFAULT = 100.0f;
    private static final Class CIRCUIT_BREAKER_INCLUDED_EXCEPTIONS_DEFAULT = JedisConnectionException.class;
    private final ClusterConfig[] clusterConfigs;
    private int retryMaxAttempts;
    private Duration retryWaitDuration;
    private int retryWaitDurationExponentialBackoffMultiplier;
    private List<Class> retryIncludedExceptionList;
    private List<Class> retryIgnoreExceptionList;
    private float circuitBreakerFailureRateThreshold;
    private int circuitBreakerSlidingWindowMinCalls;
    private CircuitBreakerConfig.SlidingWindowType circuitBreakerSlidingWindowType;
    private int circuitBreakerSlidingWindowSize;
    private Duration circuitBreakerSlowCallDurationThreshold;
    private float circuitBreakerSlowCallRateThreshold;
    private List<Class> circuitBreakerIncludedExceptionList;
    private List<Class> circuitBreakerIgnoreExceptionList;

    public MultiClusterClientConfig(ClusterConfig[] clusterConfigs) {
        this.clusterConfigs = clusterConfigs;
    }

    public ClusterConfig[] getClusterConfigs() {
        return this.clusterConfigs;
    }

    public int getRetryMaxAttempts() {
        return this.retryMaxAttempts;
    }

    public Duration getRetryWaitDuration() {
        return this.retryWaitDuration;
    }

    public int getRetryWaitDurationExponentialBackoffMultiplier() {
        return this.retryWaitDurationExponentialBackoffMultiplier;
    }

    public float getCircuitBreakerFailureRateThreshold() {
        return this.circuitBreakerFailureRateThreshold;
    }

    public int getCircuitBreakerSlidingWindowMinCalls() {
        return this.circuitBreakerSlidingWindowMinCalls;
    }

    public int getCircuitBreakerSlidingWindowSize() {
        return this.circuitBreakerSlidingWindowSize;
    }

    public Duration getCircuitBreakerSlowCallDurationThreshold() {
        return this.circuitBreakerSlowCallDurationThreshold;
    }

    public float getCircuitBreakerSlowCallRateThreshold() {
        return this.circuitBreakerSlowCallRateThreshold;
    }

    public List<Class> getRetryIncludedExceptionList() {
        return this.retryIncludedExceptionList;
    }

    public List<Class> getRetryIgnoreExceptionList() {
        return this.retryIgnoreExceptionList;
    }

    public List<Class> getCircuitBreakerIncludedExceptionList() {
        return this.circuitBreakerIncludedExceptionList;
    }

    public List<Class> getCircuitBreakerIgnoreExceptionList() {
        return this.circuitBreakerIgnoreExceptionList;
    }

    public CircuitBreakerConfig.SlidingWindowType getCircuitBreakerSlidingWindowType() {
        return this.circuitBreakerSlidingWindowType;
    }

    static /* synthetic */ CircuitBreakerConfig.SlidingWindowType access$000() {
        return CIRCUIT_BREAKER_SLIDING_WINDOW_TYPE_DEFAULT;
    }

    public static class Builder {
        private ClusterConfig[] clusterConfigs;
        private int retryMaxAttempts = 3;
        private int retryWaitDuration = 500;
        private int retryWaitDurationExponentialBackoffMultiplier = 2;
        private List<Class> retryIncludedExceptionList;
        private List<Class> retryIgnoreExceptionList;
        private float circuitBreakerFailureRateThreshold = 50.0f;
        private int circuitBreakerSlidingWindowMinCalls = 100;
        private CircuitBreakerConfig.SlidingWindowType circuitBreakerSlidingWindowType = MultiClusterClientConfig.access$000();
        private int circuitBreakerSlidingWindowSize = 100;
        private int circuitBreakerSlowCallDurationThreshold = 60000;
        private float circuitBreakerSlowCallRateThreshold = 100.0f;
        private List<Class> circuitBreakerIncludedExceptionList;
        private List<Class> circuitBreakerIgnoreExceptionList;
        private List<Class<? extends Throwable>> circuitBreakerFallbackExceptionList;

        public Builder(ClusterConfig[] clusterConfigs) {
            if (clusterConfigs == null || clusterConfigs.length < 1) {
                throw new JedisValidationException("ClusterClientConfigs are required for MultiClusterPooledConnectionProvider");
            }
            for (int i = 0; i < clusterConfigs.length; ++i) {
                clusterConfigs[i].setPriority(i + 1);
            }
            this.clusterConfigs = clusterConfigs;
        }

        public Builder retryMaxAttempts(int retryMaxAttempts) {
            this.retryMaxAttempts = retryMaxAttempts;
            return this;
        }

        public Builder retryWaitDuration(int retryWaitDuration) {
            this.retryWaitDuration = retryWaitDuration;
            return this;
        }

        public Builder retryWaitDurationExponentialBackoffMultiplier(int retryWaitDurationExponentialBackoffMultiplier) {
            this.retryWaitDurationExponentialBackoffMultiplier = retryWaitDurationExponentialBackoffMultiplier;
            return this;
        }

        public Builder retryIncludedExceptionList(List<Class> retryIncludedExceptionList) {
            this.retryIncludedExceptionList = retryIncludedExceptionList;
            return this;
        }

        public Builder retryIgnoreExceptionList(List<Class> retryIgnoreExceptionList) {
            this.retryIgnoreExceptionList = retryIgnoreExceptionList;
            return this;
        }

        public Builder circuitBreakerFailureRateThreshold(float circuitBreakerFailureRateThreshold) {
            this.circuitBreakerFailureRateThreshold = circuitBreakerFailureRateThreshold;
            return this;
        }

        public Builder circuitBreakerSlidingWindowMinCalls(int circuitBreakerSlidingWindowMinCalls) {
            this.circuitBreakerSlidingWindowMinCalls = circuitBreakerSlidingWindowMinCalls;
            return this;
        }

        public Builder circuitBreakerSlidingWindowType(CircuitBreakerConfig.SlidingWindowType circuitBreakerSlidingWindowType) {
            this.circuitBreakerSlidingWindowType = circuitBreakerSlidingWindowType;
            return this;
        }

        public Builder circuitBreakerSlidingWindowSize(int circuitBreakerSlidingWindowSize) {
            this.circuitBreakerSlidingWindowSize = circuitBreakerSlidingWindowSize;
            return this;
        }

        public Builder circuitBreakerSlowCallDurationThreshold(int circuitBreakerSlowCallDurationThreshold) {
            this.circuitBreakerSlowCallDurationThreshold = circuitBreakerSlowCallDurationThreshold;
            return this;
        }

        public Builder circuitBreakerSlowCallRateThreshold(float circuitBreakerSlowCallRateThreshold) {
            this.circuitBreakerSlowCallRateThreshold = circuitBreakerSlowCallRateThreshold;
            return this;
        }

        public Builder circuitBreakerIncludedExceptionList(List<Class> circuitBreakerIncludedExceptionList) {
            this.circuitBreakerIncludedExceptionList = circuitBreakerIncludedExceptionList;
            return this;
        }

        public Builder circuitBreakerIgnoreExceptionList(List<Class> circuitBreakerIgnoreExceptionList) {
            this.circuitBreakerIgnoreExceptionList = circuitBreakerIgnoreExceptionList;
            return this;
        }

        public Builder circuitBreakerFallbackExceptionList(List<Class<? extends Throwable>> circuitBreakerFallbackExceptionList) {
            this.circuitBreakerFallbackExceptionList = circuitBreakerFallbackExceptionList;
            return this;
        }

        public MultiClusterClientConfig build() {
            MultiClusterClientConfig config = new MultiClusterClientConfig(this.clusterConfigs);
            config.retryMaxAttempts = this.retryMaxAttempts;
            config.retryWaitDuration = Duration.ofMillis(this.retryWaitDuration);
            config.retryWaitDurationExponentialBackoffMultiplier = this.retryWaitDurationExponentialBackoffMultiplier;
            if (this.retryIncludedExceptionList != null && !this.retryIncludedExceptionList.isEmpty()) {
                config.retryIncludedExceptionList = this.retryIncludedExceptionList;
            } else {
                config.retryIncludedExceptionList = new ArrayList();
                config.retryIncludedExceptionList.add(RETRY_INCLUDED_EXCEPTIONS_DEFAULT);
            }
            if (this.retryIgnoreExceptionList != null && !this.retryIgnoreExceptionList.isEmpty()) {
                config.retryIgnoreExceptionList = this.retryIgnoreExceptionList;
            }
            config.circuitBreakerFailureRateThreshold = this.circuitBreakerFailureRateThreshold;
            config.circuitBreakerSlidingWindowMinCalls = this.circuitBreakerSlidingWindowMinCalls;
            config.circuitBreakerSlidingWindowType = this.circuitBreakerSlidingWindowType;
            config.circuitBreakerSlidingWindowSize = this.circuitBreakerSlidingWindowSize;
            config.circuitBreakerSlowCallDurationThreshold = Duration.ofMillis(this.circuitBreakerSlowCallDurationThreshold);
            config.circuitBreakerSlowCallRateThreshold = this.circuitBreakerSlowCallRateThreshold;
            if (this.circuitBreakerIncludedExceptionList != null && !this.circuitBreakerIncludedExceptionList.isEmpty()) {
                config.circuitBreakerIncludedExceptionList = this.circuitBreakerIncludedExceptionList;
            } else {
                config.circuitBreakerIncludedExceptionList = new ArrayList();
                config.circuitBreakerIncludedExceptionList.add(CIRCUIT_BREAKER_INCLUDED_EXCEPTIONS_DEFAULT);
            }
            if (this.circuitBreakerIgnoreExceptionList != null && !this.circuitBreakerIgnoreExceptionList.isEmpty()) {
                config.circuitBreakerIgnoreExceptionList = this.circuitBreakerIgnoreExceptionList;
            }
            return config;
        }
    }

    public static class ClusterConfig {
        private int priority;
        private HostAndPort hostAndPort;
        private JedisClientConfig clientConfig;

        public ClusterConfig(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
            this.hostAndPort = hostAndPort;
            this.clientConfig = clientConfig;
        }

        public int getPriority() {
            return this.priority;
        }

        private void setPriority(int priority) {
            this.priority = priority;
        }

        public HostAndPort getHostAndPort() {
            return this.hostAndPort;
        }

        public JedisClientConfig getJedisClientConfig() {
            return this.clientConfig;
        }
    }
}

