/*
 * Decompiled with CFR 0.152.
 */
package sbtdocker;

import java.io.File;
import sbt.IO$;
import sbt.Logger;
import sbt.package$;
import sbtdocker.BuildOptions;
import sbtdocker.BuildOptions$Pull$Always$;
import sbtdocker.BuildOptions$Pull$IfMissing$;
import sbtdocker.BuildOptions$Remove$Always$;
import sbtdocker.BuildOptions$Remove$Never$;
import sbtdocker.BuildOptions$Remove$OnSuccess$;
import sbtdocker.DockerTag$;
import sbtdocker.DockerfileLike;
import sbtdocker.ImageId;
import sbtdocker.ImageName;
import sbtdocker.staging.DockerfileProcessor;
import sbtdocker.staging.SourceFile;
import sbtdocker.staging.StagedDockerfile;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.sys.process.ProcessLogger$;
import scala.util.matching.Regex;

public final class DockerBuild$ {
    public static final DockerBuild$ MODULE$;
    private final Regex sbtdocker$DockerBuild$$SuccessfullyBuilt;

    static {
        new DockerBuild$();
    }

    public ImageId apply(DockerfileLike dockerfile, DockerfileProcessor processor, Seq<ImageName> imageNames, BuildOptions buildOptions, File stageDir, String dockerPath, Logger log) {
        StagedDockerfile staged = processor.apply(dockerfile, stageDir);
        return this.apply(staged, imageNames, buildOptions, stageDir, dockerPath, log);
    }

    public ImageId apply(StagedDockerfile staged, Seq<ImageName> imageNames, BuildOptions buildOptions, File stageDir, String dockerPath, Logger log) {
        log.debug((Function0)new Serializable(staged){
            public static final long serialVersionUID = 0L;
            private final StagedDockerfile staged$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Building Dockerfile:\n").append((Object)this.staged$1.instructionsString()).toString();
            }
            {
                this.staged$1 = staged$1;
            }
        });
        log.debug((Function0)new Serializable(stageDir){
            public static final long serialVersionUID = 0L;
            private final File stageDir$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preparing stage directory '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stageDir$1.getPath()}));
            }
            {
                this.stageDir$1 = stageDir$1;
            }
        });
        this.clean(stageDir);
        this.createDockerfile(staged, stageDir);
        this.prepareFiles(staged);
        return this.buildAndTag(imageNames, stageDir, dockerPath, buildOptions, log);
    }

    public void clean(File stageDir) {
        IO$.MODULE$.delete(stageDir);
    }

    public void createDockerfile(StagedDockerfile staged, File stageDir) {
        IO$.MODULE$.write(package$.MODULE$.richFile(stageDir).$div("Dockerfile"), staged.instructionsString(), IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
    }

    public void prepareFiles(StagedDockerfile staged) {
        staged.stageFiles().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<SourceFile, File> x0$1) {
                Tuple2<SourceFile, File> tuple2 = x0$1;
                if (tuple2 != null) {
                    SourceFile source = (SourceFile)tuple2._1();
                    File destination = (File)tuple2._2();
                    source.stage(destination);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public Regex sbtdocker$DockerBuild$$SuccessfullyBuilt() {
        return this.sbtdocker$DockerBuild$$SuccessfullyBuilt;
    }

    public ImageId buildAndTag(Seq<ImageName> imageNames, File stageDir, String dockerPath, BuildOptions buildOptions, Logger log) {
        ProcessLogger processLogger = ProcessLogger$.MODULE$.apply((Function1)new Serializable(log){
            public static final long serialVersionUID = 0L;
            private final Logger log$1;

            public final void apply(String line) {
                this.log$1.info((Function0)new Serializable(this, line){
                    public static final long serialVersionUID = 0L;
                    private final String line$1;

                    public final String apply() {
                        return this.line$1;
                    }
                    {
                        this.line$1 = line$1;
                    }
                });
            }
            {
                this.log$1 = log$1;
            }
        }, (Function1)new Serializable(log){
            public static final long serialVersionUID = 0L;
            private final Logger log$1;

            public final void apply(String line) {
                this.log$1.info((Function0)new Serializable(this, line){
                    public static final long serialVersionUID = 0L;
                    private final String line$2;

                    public final String apply() {
                        return this.line$2;
                    }
                    {
                        this.line$2 = line$2;
                    }
                });
            }
            {
                this.log$1 = log$1;
            }
        });
        ImageId imageId = this.build(stageDir, dockerPath, buildOptions, log, processLogger);
        imageNames.foreach((Function1)new Serializable(dockerPath, log, imageId){
            public static final long serialVersionUID = 0L;
            private final String dockerPath$1;
            private final Logger log$1;
            private final ImageId imageId$1;

            public final void apply(ImageName name) {
                DockerTag$.MODULE$.apply(this.imageId$1, name, this.dockerPath$1, this.log$1);
            }
            {
                this.dockerPath$1 = dockerPath$1;
                this.log$1 = log$1;
                this.imageId$1 = imageId$1;
            }
        });
        return imageId;
    }

    public ImageId build(File stageDir, String dockerPath, BuildOptions buildOptions, Logger log, ProcessLogger processLogger) {
        Option imageId;
        List<String> flags = this.buildFlags(buildOptions);
        String string = dockerPath;
        String string2 = "build";
        List<String> list = flags;
        String string3 = ".";
        List command = Nil$.MODULE$.$colon$colon((Object)string3).$colon$colon$colon(list).$colon$colon((Object)string2).$colon$colon((Object)string);
        log.debug((Function0)new Serializable(stageDir, command){
            public static final long serialVersionUID = 0L;
            private final File stageDir$2;
            private final List command$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running command: '", "' in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.command$1.mkString(" "), package$.MODULE$.singleFileFinder(this.stageDir$2).absString()}));
            }
            {
                this.stageDir$2 = stageDir$2;
                this.command$1 = command$1;
            }
        });
        Stream processOutput = Process$.MODULE$.apply((Seq)command, stageDir, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).lines(processLogger);
        processOutput.foreach((Function1)new Serializable(log){
            public static final long serialVersionUID = 0L;
            private final Logger log$2;

            public final void apply(String line) {
                this.log$2.info((Function0)new Serializable(this, line){
                    public static final long serialVersionUID = 0L;
                    private final String line$3;

                    public final String apply() {
                        return this.line$3;
                    }
                    {
                        this.line$3 = line$3;
                    }
                });
            }
            {
                this.log$2 = log$2;
            }
        });
        Option option = imageId = ((TraversableLike)processOutput.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = DockerBuild$.MODULE$.sbtdocker$DockerBuild$$SuccessfullyBuilt().unapplySeq(A1);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String id = (String)((LinearSeqOptimized)option.get()).apply(0);
                    object = new ImageId(id);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                Option option = DockerBuild$.MODULE$.sbtdocker$DockerBuild$$SuccessfullyBuilt().unapplySeq((Object)string);
                boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0;
                return bl;
            }
        }, Stream$.MODULE$.canBuildFrom())).lastOption();
        if (option instanceof Some) {
            ImageId id;
            Some some = (Some)option;
            ImageId imageId2 = id = (ImageId)some.x();
            return imageId2;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw scala.sys.package$.MODULE$.error("Could not parse image id");
        }
        throw new MatchError((Object)option);
    }

    public List<String> buildFlags(BuildOptions buildOptions) {
        BuildOptions.Remove.Option option;
        block5: {
            BuildOptions.Pull.Option option2;
            block8: {
                boolean bl;
                String removeFlag;
                String cacheFlag;
                block7: {
                    block6: {
                        String string;
                        block3: {
                            block4: {
                                block2: {
                                    cacheFlag = new StringBuilder().append((Object)"--no-cache=").append((Object)BoxesRunTime.boxToBoolean((!buildOptions.cache() ? 1 : 0) != 0)).toString();
                                    option = buildOptions.removeIntermediateContainers();
                                    BuildOptions$Remove$Always$ buildOptions$Remove$Always$ = BuildOptions$Remove$Always$.MODULE$;
                                    BuildOptions.Remove.Option option3 = option;
                                    if (buildOptions$Remove$Always$ != null ? !buildOptions$Remove$Always$.equals(option3) : option3 != null) break block2;
                                    string = "--force-rm=true";
                                    break block3;
                                }
                                BuildOptions$Remove$Never$ buildOptions$Remove$Never$ = BuildOptions$Remove$Never$.MODULE$;
                                BuildOptions.Remove.Option option4 = option;
                                if (buildOptions$Remove$Never$ != null ? !buildOptions$Remove$Never$.equals(option4) : option4 != null) break block4;
                                string = "--rm=false";
                                break block3;
                            }
                            BuildOptions$Remove$OnSuccess$ buildOptions$Remove$OnSuccess$ = BuildOptions$Remove$OnSuccess$.MODULE$;
                            BuildOptions.Remove.Option option5 = option;
                            if (buildOptions$Remove$OnSuccess$ != null ? !buildOptions$Remove$OnSuccess$.equals(option5) : option5 != null) break block5;
                            string = "--rm=true";
                        }
                        removeFlag = string;
                        option2 = buildOptions.pullBaseImage();
                        BuildOptions$Pull$Always$ buildOptions$Pull$Always$ = BuildOptions$Pull$Always$.MODULE$;
                        BuildOptions.Pull.Option option6 = option2;
                        if (buildOptions$Pull$Always$ != null ? !buildOptions$Pull$Always$.equals(option6) : option6 != null) break block6;
                        bl = true;
                        break block7;
                    }
                    BuildOptions$Pull$IfMissing$ buildOptions$Pull$IfMissing$ = BuildOptions$Pull$IfMissing$.MODULE$;
                    BuildOptions.Pull.Option option7 = option2;
                    if (buildOptions$Pull$IfMissing$ != null ? !buildOptions$Pull$IfMissing$.equals(option7) : option7 != null) break block8;
                    bl = false;
                }
                boolean value = bl;
                String pullFlag = new StringBuilder().append((Object)"--pull=").append((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString();
                String string = cacheFlag;
                String string2 = removeFlag;
                String string3 = pullFlag;
                return Nil$.MODULE$.$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    private DockerBuild$() {
        MODULE$ = this;
        this.sbtdocker$DockerBuild$$SuccessfullyBuilt = new StringOps(Predef$.MODULE$.augmentString("^Successfully built ([0-9a-f]+)$")).r();
    }
}

