/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.http;

import java.io.IOException;
import java.util.Iterator;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.servicemix.jbi.jaxp.SourceTransformer;
import org.servicemix.jbi.jaxp.StringSource;

public class HttpClientMarshaler {
    private SourceTransformer sourceTransformer = new SourceTransformer();

    public void toNMS(NormalizedMessage normalizedMessage, HttpMethod method) throws IOException, MessagingException {
        this.addNmsProperties(normalizedMessage, method);
        normalizedMessage.setContent((Source)new StringSource(method.getResponseBodyAsString()));
    }

    public void fromNMS(PostMethod method, NormalizedMessage normalizedMessage) throws IOException, MessagingException, TransformerException {
        this.addHttpHeaders((HttpMethod)method, normalizedMessage);
        String text = this.sourceTransformer.toString(normalizedMessage.getContent());
        method.setRequestEntity((RequestEntity)new StringRequestEntity(text));
    }

    protected void addHttpHeaders(HttpMethod method, NormalizedMessage normalizedMessage) {
        Iterator iter = normalizedMessage.getPropertyNames().iterator();
        while (iter.hasNext()) {
            Object value;
            String name = (String)iter.next();
            if (!this.shouldIncludeHeader(normalizedMessage, name, value = normalizedMessage.getProperty(name))) continue;
            method.addRequestHeader(name, value.toString());
        }
    }

    protected void addNmsProperties(NormalizedMessage message, HttpMethod method) {
        Header[] headers = method.getResponseHeaders();
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            String name = header.getName();
            String value = header.getValue();
            message.setProperty(name, (Object)value);
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return value instanceof String && !"Content-Length".equals(name) && !"Content-Type".equals(name);
    }
}

