/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.http;

import java.io.IOException;
import javax.jbi.JBIException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.servicemix.components.http.HttpBindingSupport;
import org.servicemix.components.http.HttpMarshaler;

public class HttpInOutBinding
extends HttpBindingSupport {
    private boolean defaultInOut = true;

    public void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, JBIException {
        if (this.isInOutRequest(request, response)) {
            this.processInOut(request, response);
        } else {
            this.processInOnly(request, response);
        }
    }

    public void processInOut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, JBIException {
        MessageExchangeFactory factory = this.getExchangeFactory();
        InOut exchange = factory.createInOutExchange();
        NormalizedMessage inMessage = exchange.createMessage();
        try {
            this.getMarshaler().toNMS((MessageExchange)exchange, inMessage, request);
            exchange.setInMessage(inMessage);
            boolean result = this.getDeliveryChannel().sendSync((MessageExchange)exchange);
            if (result) {
                this.getMarshaler().toResponse(exchange, exchange.getOutMessage(), response);
            }
            this.done((MessageExchange)exchange);
            response.setStatus(200);
        }
        catch (IOException e) {
            this.fail((MessageExchange)exchange, e);
            this.outputException(response, e);
        }
        catch (TransformerException e) {
            this.fail((MessageExchange)exchange, e);
            this.outputException(response, e);
        }
    }

    public void processInOnly(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, JBIException {
        MessageExchangeFactory factory = this.getExchangeFactory();
        InOnly exchange = factory.createInOnlyExchange();
        NormalizedMessage inMessage = exchange.createMessage();
        try {
            HttpMarshaler marshaler = this.getMarshaler();
            marshaler.toNMS((MessageExchange)exchange, inMessage, request);
            exchange.setInMessage(inMessage);
            this.done((MessageExchange)exchange);
            response.setStatus(200);
        }
        catch (IOException e) {
            this.fail((MessageExchange)exchange, e);
            this.outputException(response, e);
        }
    }

    public boolean isDefaultInOut() {
        return this.defaultInOut;
    }

    public void setDefaultInOut(boolean defaultInOut) {
        this.defaultInOut = defaultInOut;
    }

    protected boolean isInOutRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.isDefaultInOut();
    }
}

