/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.jabber;

import javax.jbi.JBIException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.servicemix.components.jabber.JabberListenerException;
import org.servicemix.components.jabber.JabberMarshaler;
import org.servicemix.components.util.OutBinding;
import org.springframework.beans.factory.InitializingBean;

public abstract class JabberComponentSupport
extends OutBinding
implements InitializingBean,
PacketListener {
    private static final transient Log log = LogFactory.getLog((Class)JabberComponentSupport.class);
    private JabberMarshaler marshaler = new JabberMarshaler();
    private XMPPConnection connection;
    private String host;
    private int port;
    private String user;
    private String password;
    private String resource = "ServiceMix";
    private boolean login = true;

    public void afterPropertiesSet() throws Exception {
        if (this.connection == null && this.host == null) {
            throw new IllegalArgumentException("You must specify the connection or the host property");
        }
    }

    public void start() throws JBIException {
        try {
            if (this.connection == null) {
                this.connection = this.port > 0 ? new XMPPConnection(this.host, this.port) : new XMPPConnection(this.host);
            }
            if (this.login && !this.connection.isAuthenticated()) {
                if (this.user != null) {
                    AccountManager accountManager = new AccountManager(this.connection);
                    accountManager.createAccount(this.user, this.password);
                    log.info((Object)("Logging in to Jabber as user: " + this.user + " on connection: " + this.connection));
                    this.connection.login(this.user, this.password, this.resource);
                } else {
                    log.info((Object)("Logging in anonymously to Jabber on connection: " + this.connection));
                    this.connection.loginAnonymously();
                }
            }
        }
        catch (XMPPException e) {
            throw new JBIException("Failed to login to Jabber. Reason: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void stop() throws JBIException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void processPacket(Packet packet) {
        try {
            InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
            NormalizedMessage in = exchange.createMessage();
            exchange.setInMessage(in);
            this.marshaler.toNMS(in, packet);
            this.done((MessageExchange)exchange);
        }
        catch (MessagingException e) {
            throw new JabberListenerException((Exception)((Object)e), packet);
        }
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public void setConnection(XMPPConnection connection) {
        this.connection = connection;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public JabberMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(JabberMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }
}

