/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.rss;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jbi.JBIException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.servicemix.components.util.PollingComponentSupport;

public class RssPollingComponent
extends PollingComponentSupport {
    private static final Log log = LogFactory.getLog((Class)RssPollingComponent.class);
    private List urlStrings = new ArrayList();
    private List urls = new ArrayList();
    private Date lastPolledDate = new Date();
    private String outputType = "rss_2.0";

    public List getUrlStrings() {
        return this.urlStrings;
    }

    public void setUrlStrings(List urlStrings) {
        this.urlStrings = urlStrings;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public Date getLastPolledDate() {
        return this.lastPolledDate;
    }

    public void setLastPolledDate(Date lastPolledDate) {
        this.lastPolledDate = lastPolledDate;
    }

    protected void init() throws JBIException {
        this.urls.clear();
        if (this.urlStrings != null) {
            for (int i = 0; i < this.urlStrings.size(); ++i) {
                try {
                    this.urls.add(new URL(this.urlStrings.get(i).toString()));
                    continue;
                }
                catch (MalformedURLException e) {
                    log.warn((Object)("URL: " + this.urlStrings.get(i) + " is badly formed"), (Throwable)e);
                }
            }
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() {
        List list = this.getLastesEntries();
        if (list != null && !list.isEmpty()) {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(this.outputType);
            feed.setTitle("Aggregated Feed");
            feed.setDescription("Anonymous Aggregated Feed");
            feed.setAuthor("servicemix");
            feed.setLink("http://www.servicemix.org");
            feed.setEntries(list);
            SyndFeedOutput output = new SyndFeedOutput();
            try {
                DOMSource source = new DOMSource(output.outputW3CDom((SyndFeed)feed));
                InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
                NormalizedMessage message = exchange.createMessage();
                message.setContent((Source)source);
                exchange.setInMessage(message);
                this.send((MessageExchange)exchange);
            }
            catch (Exception e) {
                log.error((Object)"Failed to send RSS message to the NMR");
            }
            finally {
                this.lastPolledDate = new Date();
            }
        }
    }

    protected List getLastesEntries() {
        ArrayList<SyndEntry> result = new ArrayList<SyndEntry>();
        SyndFeedInput input = new SyndFeedInput();
        for (int i = 0; i < this.urls.size(); ++i) {
            URL inputUrl = (URL)this.urls.get(i);
            try {
                SyndFeed inFeed = input.build((Reader)new XmlReader(inputUrl));
                List entries = inFeed.getEntries();
                for (int k = 0; k < entries.size(); ++k) {
                    SyndEntry entry = (SyndEntry)entries.get(k);
                    if (!entry.getPublishedDate().after(this.getLastPolledDate())) continue;
                    result.add(entry);
                }
                continue;
            }
            catch (Exception e) {
                log.warn((Object)("Failed to process feed from: " + inputUrl), (Throwable)e);
            }
        }
        return result;
    }
}

