/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.saaj;

import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.servicemix.MessageExchangeListener;
import org.servicemix.components.saaj.SaajMarshaler;
import org.servicemix.components.util.ComponentSupport;

public class SaajBinding
extends ComponentSupport
implements MessageExchangeListener {
    private static final transient Log log = LogFactory.getLog((Class)SaajBinding.class);
    private SaajMarshaler marshaler = new SaajMarshaler();
    private SOAPConnectionFactory connectionFactory;
    private Object soapEndpoint;

    public SOAPConnectionFactory getConnectionFactory() throws SOAPException {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(SOAPConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Object getSoapEndpoint() {
        return this.soapEndpoint;
    }

    public void setSoapEndpoint(Object soapEndpoint) {
        this.soapEndpoint = soapEndpoint;
    }

    public SaajMarshaler getMarshaller() {
        return this.marshaler;
    }

    public void setMarshaller(SaajMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageExchange(MessageExchange exchange) throws MessagingException {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            this.done(exchange);
            return;
        }
        SOAPConnection connection = null;
        try {
            connection = this.getConnectionFactory().createConnection();
            SOAPMessage inMessage = this.marshaler.createSOAPMessage(exchange.getMessage("in"));
            SOAPMessage response = connection.call(inMessage, this.soapEndpoint);
            NormalizedMessage outMessage = exchange.createMessage();
            this.marshaler.toNMS(outMessage, response);
            this.answer(exchange, outMessage);
        }
        catch (Exception e) {
            this.fail(exchange, e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SOAPException e) {
                    log.warn((Object)("Failed to close connection: " + (Object)((Object)e)), (Throwable)e);
                }
            }
        }
    }

    protected SOAPConnectionFactory createConnectionFactory() throws SOAPException {
        return SOAPConnectionFactory.newInstance();
    }

    protected SOAPConnection createConnection() throws SOAPException {
        return this.getConnectionFactory().createConnection();
    }
}

