/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.saaj;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.servicemix.jbi.jaxp.SourceTransformer;
import org.w3c.dom.Document;

public class SaajMarshaler {
    private static final transient Log log = LogFactory.getLog((Class)SaajMarshaler.class);
    protected SourceTransformer transformer = new SourceTransformer();
    private MessageFactory messageFactory;

    public void toNMS(NormalizedMessage normalizedMessage, SOAPMessage soapMessage) throws MessagingException, SOAPException {
        this.addNmsProperties(normalizedMessage, soapMessage);
        SOAPPart soapPart = soapMessage.getSOAPPart();
        normalizedMessage.setContent(soapPart.getContent());
        this.addNmsAttachments(normalizedMessage, soapMessage);
    }

    public SOAPMessage createSOAPMessage(NormalizedMessage normalizedMessage) throws SOAPException, IOException, TransformerException {
        SOAPMessage soapMessage = this.getMessageFactory().createMessage();
        this.addSoapProperties(soapMessage, normalizedMessage);
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        SOAPBody body = envelope.getBody();
        DOMResult result = new DOMResult(null);
        this.transformer.toResult(normalizedMessage.getContent(), (Result)result);
        Document document = (Document)result.getNode();
        body.addDocument(document);
        this.addSoapAttachments(soapMessage, normalizedMessage);
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)buffer);
            log.debug((Object)new String(buffer.toByteArray()));
        }
        return soapMessage;
    }

    public MessageFactory getMessageFactory() throws SOAPException {
        if (this.messageFactory == null) {
            this.messageFactory = this.createMessageFactory();
        }
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    protected void addNmsProperties(NormalizedMessage normalizedMessage, SOAPMessage soapMessage) {
        Iterator iter = soapMessage.getMimeHeaders().getAllHeaders();
        while (iter.hasNext()) {
            MimeHeader header = (MimeHeader)iter.next();
            normalizedMessage.setProperty(header.getName(), (Object)header.getValue());
        }
    }

    protected void addNmsAttachments(NormalizedMessage normalizedMessage, SOAPMessage soapMessage) throws MessagingException, SOAPException {
        Iterator iter = soapMessage.getAttachments();
        while (iter.hasNext()) {
            AttachmentPart attachment = (AttachmentPart)iter.next();
            normalizedMessage.addAttachment(attachment.getContentId(), this.asDataHandler(attachment));
        }
    }

    protected void addSoapProperties(SOAPMessage soapMessage, NormalizedMessage normalizedMessage) throws SOAPException {
        Iterator iter = normalizedMessage.getPropertyNames().iterator();
        while (iter.hasNext()) {
            Object value;
            String name = (String)iter.next();
            if (this.shouldIncludeHeader(normalizedMessage, name, value = normalizedMessage.getProperty(name))) {
                soapMessage.getMimeHeaders().addHeader(name, value.toString());
            }
            if (!this.shouldIncludeProperty(normalizedMessage, name, value)) continue;
            soapMessage.setProperty(name, value);
        }
    }

    protected void addSoapAttachments(SOAPMessage soapMessage, NormalizedMessage normalizedMessage) throws IOException {
        Iterator iterator = normalizedMessage.getAttachmentNames().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            DataHandler attachment = normalizedMessage.getAttachment(name);
            AttachmentPart attachmentPart = soapMessage.createAttachmentPart(attachment.getContent(), attachment.getContentType());
            attachmentPart.setContentId(name);
            soapMessage.addAttachmentPart(attachmentPart);
        }
    }

    protected boolean shouldIncludeHeader(NormalizedMessage normalizedMessage, String name, Object value) {
        return true;
    }

    private boolean shouldIncludeProperty(NormalizedMessage normalizedMessage, String name, Object value) {
        return true;
    }

    protected DataHandler asDataHandler(AttachmentPart attachment) throws SOAPException {
        return new DataHandler(attachment.getContent(), attachment.getContentType());
    }

    protected MessageFactory createMessageFactory() throws SOAPException {
        return MessageFactory.newInstance();
    }
}

