/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.validation;

import java.io.IOException;
import javax.jbi.JBIException;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.servicemix.components.util.TransformComponentSupport;
import org.servicemix.components.validation.CountingErrorHandler;
import org.servicemix.jbi.FaultException;
import org.servicemix.jbi.jaxp.SourceTransformer;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class ValidateComponent
extends TransformComponentSupport {
    private Schema schema;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Source schemaSource;
    private Resource schemaResource;

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public Source getSchemaSource() {
        return this.schemaSource;
    }

    public void setSchemaSource(Source schemaSource) {
        this.schemaSource = schemaSource;
    }

    public Resource getSchemaResource() {
        return this.schemaResource;
    }

    public void setSchemaResource(Resource schemaResource) {
        this.schemaResource = schemaResource;
    }

    protected void init() throws JBIException {
        super.init();
        try {
            if (this.schema == null) {
                SchemaFactory factory = SchemaFactory.newInstance(this.schemaLanguage);
                if (this.schemaSource == null) {
                    if (this.schemaResource == null) {
                        throw new JBIException("You must specify a schema, schemaSource or schemaResource property");
                    }
                    this.schemaSource = new StreamSource(this.schemaResource.getInputStream());
                }
                this.schema = factory.newSchema(this.schemaSource);
            }
        }
        catch (IOException e) {
            throw new JBIException("Failed to load schema: " + e, (Throwable)e);
        }
        catch (SAXException e) {
            throw new JBIException("Failed to load schema: " + e, (Throwable)e);
        }
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        Validator validator = this.schema.newValidator();
        CountingErrorHandler errorHandler = new CountingErrorHandler();
        validator.setErrorHandler(errorHandler);
        DOMResult result = new DOMResult();
        this.getMessageTransformer().transform(exchange, in, out);
        try {
            DOMSource src = new SourceTransformer().toDOMSource(out.getContent());
            validator.validate(src, result);
            if (errorHandler.hasErrors()) {
                Fault fault = exchange.createFault();
                fault.setProperty("org.servicemix.schema", (Object)this.schema);
                fault.setContent((Source)new DOMSource(result.getNode(), result.getSystemId()));
                throw new FaultException("Failed to validate against schema: " + this.schema, exchange, fault);
            }
            out.setContent((Source)new DOMSource(result.getNode(), result.getSystemId()));
            return true;
        }
        catch (SAXException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
    }
}

