/*
 * Decompiled with CFR 0.152.
 */
package org.servicemix.components.wsif;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFService;
import org.apache.wsif.WSIFServiceFactory;
import org.apache.wsif.util.WSIFUtils;
import org.servicemix.components.util.TransformComponentSupport;
import org.servicemix.components.wsif.WSIFMarshaler;
import org.servicemix.components.wsif.WSIFOperationInfo;
import org.servicemix.components.wsif.WSIFOperationMap;
import org.springframework.core.io.Resource;

public class WSIFBinding
extends TransformComponentSupport {
    private WSIFMarshaler marshaler = new WSIFMarshaler();
    private WSIFService serviceHelper;
    private Definition definition;
    private Resource definitionResource;
    private WSIFServiceFactory factory = WSIFServiceFactory.newInstance();
    private WSIFOperationMap operationMap;

    protected void init() throws JBIException {
        try {
            if (this.definition == null) {
                if (this.definitionResource == null) {
                    throw new JBIException("You must specify a definition or definitionResource property");
                }
                String uri = this.definitionResource.getURL().toString();
                InputStreamReader reader = new InputStreamReader(this.definitionResource.getInputStream());
                this.definition = WSIFUtils.readWSDL((String)uri, (Reader)reader);
            }
            if (this.serviceHelper == null) {
                this.serviceHelper = this.factory.getService(this.definition);
            }
            Iterator iter = this.serviceHelper.getAvailablePortNames();
            while (iter.hasNext()) {
                System.out.println("Available port name: " + iter.next());
            }
            this.operationMap = new WSIFOperationMap(this.serviceHelper);
            Map bindings = this.definition.getBindings();
            Iterator iter2 = bindings.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                Binding binding = (Binding)entry.getValue();
                this.operationMap.addBinding(binding);
            }
        }
        catch (IOException e) {
            throw new JBIException((Throwable)e);
        }
        catch (WSDLException e) {
            throw new JBIException((Throwable)e);
        }
    }

    public WSIFMarshaler getMarshaller() {
        return this.marshaler;
    }

    public void setMarshaller(WSIFMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public WSIFMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(WSIFMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public Resource getDefinitionResource() {
        return this.definitionResource;
    }

    public void setDefinitionResource(Resource definitionResource) {
        this.definitionResource = definitionResource;
    }

    public WSIFServiceFactory getFactory() {
        return this.factory;
    }

    public void setFactory(WSIFServiceFactory factory) {
        this.factory = factory;
    }

    public WSIFService getServiceHelper() {
        return this.serviceHelper;
    }

    public void setServiceHelper(WSIFService serviceHelper) {
        this.serviceHelper = serviceHelper;
    }

    protected boolean transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws MessagingException {
        try {
            WSIFOperationInfo operationInfo = this.operationMap.getOperationForExchange(exchange);
            WSIFOperation operation = operationInfo.getWsifOperation();
            WSIFMessage inMessage = operation.createInputMessage();
            Object body = this.getBody(in);
            this.marshaler.fromNMS(operationInfo, inMessage, in, body);
            WSIFMessage outMessage = operation.createInputMessage();
            WSIFMessage faultMessage = operation.createInputMessage();
            boolean answer = operation.executeRequestResponseOperation(inMessage, outMessage, faultMessage);
            if (answer) {
                this.marshaler.toNMS(exchange, out, operationInfo, outMessage);
            } else {
                Fault fault = exchange.createFault();
                this.marshaler.toNMS(exchange, (NormalizedMessage)fault, operationInfo, outMessage);
                exchange.setFault(fault);
            }
            return true;
        }
        catch (WSIFException e) {
            throw new MessagingException((Throwable)e);
        }
    }
}

