/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.spice.converter.Converter;
import org.codehaus.spice.converter.ConverterException;
import org.codehaus.spice.converter.ConverterFactory;
import org.codehaus.spice.salt.i18n.ResourceManager;
import org.codehaus.spice.salt.i18n.Resources;

public abstract class AbstractMasterConverter
implements Converter {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$codehaus$spice$converter$AbstractMasterConverter == null ? (class$org$codehaus$spice$converter$AbstractMasterConverter = AbstractMasterConverter.class$("org.codehaus.spice.converter.AbstractMasterConverter")) : class$org$codehaus$spice$converter$AbstractMasterConverter));
    private final Map m_converters = new HashMap();
    private final HashMap m_mapping = new HashMap();
    static /* synthetic */ Class class$org$codehaus$spice$converter$AbstractMasterConverter;

    public Object convert(Class destination, Object original, Object context) throws ConverterException {
        Class<?> originalClass = original.getClass();
        if (destination.isAssignableFrom(originalClass)) {
            return original;
        }
        try {
            Converter converter = this.findConverter(originalClass, destination);
            Object object = converter.convert(destination, original, context);
            if (destination.isInstance(object)) {
                return object;
            }
            String message = REZ.format("bad-return-type.error", (Object)object.getClass().getName(), (Object)destination.getName());
            throw new ConverterException(message);
        }
        catch (Exception e) {
            String message = REZ.format("convert.error", (Object)originalClass.getName(), (Object)destination.getName());
            throw new ConverterException(message, e);
        }
    }

    private Converter findConverter(Class originalClass, Class destination) throws Exception {
        ConverterFactory factory = this.findConverterFactory(originalClass, destination);
        Converter converter = (Converter)this.m_converters.get(factory);
        if (converter == null) {
            converter = factory.createConverter();
            this.m_converters.put(factory, converter);
        }
        return converter;
    }

    protected void registerConverter(ConverterFactory factory, String source, String destination) {
        HashMap<String, ConverterFactory> map = (HashMap<String, ConverterFactory>)this.m_mapping.get(source);
        if (null == map) {
            map = new HashMap<String, ConverterFactory>();
            this.m_mapping.put(source, map);
        }
        map.put(destination, factory);
        this.m_converters.remove(factory);
    }

    private ConverterFactory findConverterFactory(Class originalClass, Class destination) throws ConverterException {
        Class bestSrcMatch = null;
        ConverterFactory matchFactory = null;
        ArrayList queue = new ArrayList();
        queue.add(originalClass);
        while (!queue.isEmpty()) {
            Class clazz = (Class)queue.remove(0);
            if (clazz.getSuperclass() != null) {
                queue.add(clazz.getSuperclass());
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                queue.add(interfaces[i]);
                ++i;
            }
            ConverterFactory factory = this.getConverterFactory(clazz.getName(), destination.getName());
            if (factory == null) continue;
            if (bestSrcMatch == null || bestSrcMatch.isAssignableFrom(clazz)) {
                bestSrcMatch = clazz;
                matchFactory = factory;
                continue;
            }
            if (clazz.isAssignableFrom(bestSrcMatch)) continue;
            String message = REZ.getString("ambiguous-converter.error");
            throw new ConverterException(message);
        }
        if (bestSrcMatch != null) {
            return matchFactory;
        }
        String message = REZ.getString("no-converter.error");
        throw new ConverterException(message);
    }

    private ConverterFactory getConverterFactory(String source, String destination) {
        HashMap map = (HashMap)this.m_mapping.get(source);
        if (null == map) {
            return null;
        }
        return (ConverterFactory)map.get(destination);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

