/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.spice.converter;

import org.codehaus.spice.converter.Converter;
import org.codehaus.spice.converter.ConverterException;
import org.codehaus.spice.salt.i18n.ResourceManager;
import org.codehaus.spice.salt.i18n.Resources;

public abstract class AbstractConverter
implements Converter {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$codehaus$spice$converter$AbstractConverter == null ? (class$org$codehaus$spice$converter$AbstractConverter = AbstractConverter.class$("org.codehaus.spice.converter.AbstractConverter")) : class$org$codehaus$spice$converter$AbstractConverter));
    private final Class m_source;
    private final Class m_destination;
    private final Object m_defaultValue;
    static /* synthetic */ Class class$org$codehaus$spice$converter$AbstractConverter;

    protected AbstractConverter(Class source, Class destination) {
        this(source, destination, null);
    }

    protected AbstractConverter(Class source, Class destination, Object defaultValue) {
        this.m_source = source;
        this.m_destination = destination;
        this.m_defaultValue = defaultValue;
    }

    public Object convert(Class destination, Object original, Object context) throws ConverterException {
        if (this.m_destination != destination) {
            String message = REZ.format("bad-destination.error", (Object)destination.getName(), (Object)this.m_destination);
            throw new IllegalArgumentException(message);
        }
        if (!this.m_source.isInstance(original)) {
            String message = REZ.format("bad-instance.error", original, (Object)this.m_source.getName());
            throw new IllegalArgumentException(message);
        }
        return this.convert(original, context);
    }

    protected final Object noConvert(Object value, Throwable throwable) throws ConverterException {
        if (null != this.m_defaultValue) {
            return this.m_defaultValue;
        }
        String message = REZ.format("no-convert.error", (Object)this.m_source.getName(), (Object)this.m_destination.getName(), value, (Object)throwable);
        throw new ConverterException(message);
    }

    protected abstract Object convert(Object var1, Object var2) throws ConverterException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

