/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshToolsConnectionProxyTab
extends JPanel
implements SshToolsConnectionTab {
    public static final String PROXY_ICON = "/com/sshtools/common/ui/proxy.png";
    protected JRadioButton noProxy = new JRadioButton("No proxy");
    protected JRadioButton httpProxy = new JRadioButton("HTTP");
    protected JRadioButton socks4Proxy = new JRadioButton("SOCKS 4");
    protected JRadioButton socks5Proxy = new JRadioButton("SOCKS 5");
    protected ButtonGroup group = new ButtonGroup();
    protected JPanel proxyframe = new JPanel(new GridBagLayout());
    protected JTextField username = new JTextField();
    protected JPasswordField password = new JPasswordField();
    protected JTextField proxy = new JTextField();
    protected NumericTextField port = new NumericTextField(new Integer(1), new Integer(65535));
    protected SshToolsConnectionProfile profile;
    protected Log log = LogFactory.getLog((Class)(class$com$sshtools$common$ui$SshToolsConnectionProxyTab == null ? (class$com$sshtools$common$ui$SshToolsConnectionProxyTab = SshToolsConnectionProxyTab.class$("com.sshtools.common.ui.SshToolsConnectionProxyTab")) : class$com$sshtools$common$ui$SshToolsConnectionProxyTab));
    static /* synthetic */ Class class$com$sshtools$common$ui$SshToolsConnectionProxyTab;

    public SshToolsConnectionProxyTab() {
        this.group.add(this.noProxy);
        this.group.add(this.httpProxy);
        this.group.add(this.socks4Proxy);
        this.group.add(this.socks5Proxy);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SshToolsConnectionProxyTab.this.noProxy.isSelected()) {
                    SshToolsConnectionProxyTab.this.username.setEnabled(false);
                    SshToolsConnectionProxyTab.this.password.setEnabled(false);
                    SshToolsConnectionProxyTab.this.proxy.setEnabled(false);
                    SshToolsConnectionProxyTab.this.port.setForeground(Color.white);
                } else {
                    SshToolsConnectionProxyTab.this.username.setEnabled(true);
                    SshToolsConnectionProxyTab.this.password.setEnabled(true);
                    SshToolsConnectionProxyTab.this.proxy.setEnabled(true);
                    SshToolsConnectionProxyTab.this.port.setForeground(Color.black);
                    if (SshToolsConnectionProxyTab.this.httpProxy.isSelected()) {
                        SshToolsConnectionProxyTab.this.port.setText("80");
                    } else {
                        SshToolsConnectionProxyTab.this.port.setText("1080");
                    }
                }
            }
        };
        this.noProxy.getModel().addChangeListener(changeListener);
        this.httpProxy.getModel().addChangeListener(changeListener);
        this.socks4Proxy.getModel().addChangeListener(changeListener);
        this.socks5Proxy.getModel().addChangeListener(changeListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.proxyframe.setBorder(BorderFactory.createTitledBorder("Connect using the following proxy"));
        UIUtil.jGridBagAdd(this.proxyframe, this.noProxy, gridBagConstraints, 0);
        gridBagConstraints.fill = 2;
        UIUtil.jGridBagAdd(this.proxyframe, this.httpProxy, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(this.proxyframe, this.socks4Proxy, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(this.proxyframe, this.socks5Proxy, gridBagConstraints, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Proxy Details"));
        UIUtil.jGridBagAdd(jPanel, new JLabel("Host"), gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, this.proxy, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, new JLabel("Port"), gridBagConstraints, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        UIUtil.jGridBagAdd(jPanel, this.port, gridBagConstraints, 0);
        gridBagConstraints.fill = 2;
        UIUtil.jGridBagAdd(jPanel, new JLabel("Username"), gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, this.username, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, new JLabel("Password"), gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel, this.password, gridBagConstraints, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        UIUtil.jGridBagAdd(jPanel2, this.proxyframe, gridBagConstraints, 0);
        UIUtil.jGridBagAdd(jPanel2, jPanel, gridBagConstraints, 0);
        IconWrapperPanel iconWrapperPanel = new IconWrapperPanel(new ResourceIcon(PROXY_ICON), jPanel2);
        this.noProxy.setSelected(true);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)iconWrapperPanel, "North");
    }

    public void setConnectionProfile(SshToolsConnectionProfile sshToolsConnectionProfile) {
        this.profile = sshToolsConnectionProfile;
    }

    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    public String getTabContext() {
        return "Connection";
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabTitle() {
        return "Proxy";
    }

    public String getTabToolTipText() {
        return "Configure the proxy connection.";
    }

    public int getTabMnemonic() {
        return 112;
    }

    public Component getTabComponent() {
        return this;
    }

    public boolean validateTab() {
        return true;
    }

    public void applyTab() {
        if (this.httpProxy.isSelected()) {
            this.profile.setTransportProvider(2);
        } else if (this.socks4Proxy.isSelected()) {
            this.profile.setTransportProvider(3);
        } else if (this.socks5Proxy.isSelected()) {
            this.profile.setTransportProvider(4);
        } else {
            this.profile.setTransportProvider(1);
        }
        this.profile.setProxyHost(this.proxy.getText());
        this.profile.setProxyPort(this.port.getValue().intValue());
        this.profile.setProxyUsername(this.username.getText());
        this.profile.setProxyPassword(new String(this.password.getPassword()));
    }

    public void tabSelected() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

