/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.scp;

import com.sshtools.daemon.platform.InvalidHandleException;
import com.sshtools.daemon.platform.NativeFileSystemProvider;
import com.sshtools.daemon.platform.NativeProcessProvider;
import com.sshtools.daemon.platform.PermissionDeniedException;
import com.sshtools.daemon.util.StringPattern;
import com.sshtools.daemon.util.StringUtil;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScpServer
extends NativeProcessProvider
implements Runnable {
    private static Log log = LogFactory.getLog((Class)ScpServer.class);
    private static int BUFFER_SIZE = 16384;
    private InputStream in;
    private InputStream err;
    private OutputStream out;
    private String destination;
    private PipedOutputStream pipeIn;
    private PipedOutputStream pipeErr;
    private PipedInputStream pipeOut;
    private SshThread scpServerThread;
    private int verbosity = 0;
    private int exitCode;
    private boolean directory;
    private boolean recursive;
    private boolean from;
    private boolean to;
    private NativeFileSystemProvider nfs;
    private byte[] buffer = new byte[BUFFER_SIZE];
    private String currentDirectory;
    private boolean preserveAttributes;

    public ScpServer() {
        this.nfs = NativeFileSystemProvider.getInstance();
    }

    public boolean allocatePseudoTerminal(String string, int n, int n2, int n3, int n4, String string2) {
        return false;
    }

    public boolean createProcess(String string, Map map) throws IOException {
        log.info((Object)"Creating ScpServer");
        if (this.nfs == null) {
            throw new IOException("NativeFileSystem was not instantiated. Please check logs");
        }
        this.scp(string.substring(4));
        return true;
    }

    public String getDefaultTerminalProvider() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public InputStream getStderrInputStream() {
        return this.err;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public void kill() {
        log.info((Object)"Killing ScpServer");
        try {
            if (this.pipeIn != null) {
                this.pipeIn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.pipeOut != null) {
                this.pipeOut.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.pipeErr != null) {
                this.pipeErr.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() throws IOException {
        log.debug((Object)"Starting ScpServer thread");
        this.scpServerThread = SshThread.getCurrentThread().cloneThread((Runnable)this, "ScpServer");
        this.scpServerThread.start();
    }

    public boolean stillActive() {
        return false;
    }

    public boolean supportsPseudoTerminal(String string) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForExitCode() {
        try {
            ScpServer scpServer = this;
            synchronized (scpServer) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.debug((Object)("Returning exit code of " + this.exitCode));
        return this.exitCode;
    }

    private void scp(String string) throws IOException {
        log.debug((Object)("Parsing ScpServer options " + string));
        String[] stringArray = StringUtil.current().allParts(string, " ");
        this.destination = null;
        this.directory = false;
        this.from = false;
        this.to = false;
        this.recursive = false;
        this.verbosity = 0;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) {
                String string2 = stringArray[i].substring(1);
                block9: for (int j = 0; j < string2.length(); ++j) {
                    char c = string2.charAt(j);
                    switch (c) {
                        case 't': {
                            this.to = true;
                            continue block9;
                        }
                        case 'd': {
                            this.directory = true;
                            continue block9;
                        }
                        case 'f': {
                            this.from = true;
                            continue block9;
                        }
                        case 'r': {
                            this.recursive = true;
                            continue block9;
                        }
                        case 'v': {
                            ++this.verbosity;
                            continue block9;
                        }
                        case 'p': {
                            this.preserveAttributes = true;
                            continue block9;
                        }
                        default: {
                            log.warn((Object)"Unsupported argument, allowing to continue.");
                        }
                    }
                }
                continue;
            }
            if (this.destination == null) {
                this.destination = stringArray[i];
                continue;
            }
            throw new IOException("More than one destination supplied " + stringArray[i]);
        }
        if (!this.to && !this.from) {
            throw new IOException("Must supply either -t or -f.");
        }
        if (this.destination == null) {
            throw new IOException("Destination not supplied.");
        }
        log.debug((Object)("Destination is " + this.destination));
        log.debug((Object)("Recursive is " + this.recursive));
        log.debug((Object)("Directory is " + this.directory));
        log.debug((Object)("Verbosity is " + this.verbosity));
        log.debug((Object)("From is " + this.from));
        log.debug((Object)("To is " + this.to));
        log.debug((Object)("Preserve Attributes " + this.preserveAttributes));
        log.debug((Object)"Creating pipes");
        this.pipeIn = new PipedOutputStream();
        this.pipeErr = new PipedOutputStream();
        this.pipeOut = new PipedInputStream();
        this.in = new PipedInputStream(this.pipeIn);
        this.err = new PipedInputStream(this.pipeErr);
        this.out = new PipedOutputStream(this.pipeOut);
    }

    private void writeOk() throws IOException {
        log.debug((Object)"Sending client ok command");
        this.pipeIn.write(0);
        this.pipeIn.flush();
    }

    private void writeCommand(String string) throws IOException {
        log.debug((Object)("Sending command '" + string + "'"));
        this.pipeIn.write(string.getBytes());
        if (!string.endsWith("\n")) {
            this.pipeIn.write("\n".getBytes());
        }
        this.pipeIn.flush();
    }

    private void writeError(String string) throws IOException {
        this.writeError(string, false);
    }

    private void writeError(String string, boolean bl) throws IOException {
        log.debug((Object)("Sending error message '" + string + "' to client (serious=" + bl + ")"));
        this.pipeIn.write(bl ? 2 : 1);
        this.pipeIn.write(string.getBytes());
        if (!string.endsWith("\n")) {
            this.pipeIn.write(10);
        }
        this.pipeIn.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object;
        block24: {
            log.debug((Object)"Running ScpServer thread");
            try {
                if (this.from) {
                    log.info((Object)"From mode");
                    try {
                        this.waitForResponse();
                        object = new StringPattern(this.destination);
                        if (((StringPattern)object).hasWildcard()) {
                            log.debug((Object)"Path contains wildcard");
                            String string = this.destination;
                            String string2 = ".";
                            int n = string.lastIndexOf(47);
                            if (n != -1) {
                                if (n > 0) {
                                    string2 = string.substring(0, n);
                                }
                                string = string.substring(n + 1);
                            }
                            log.debug((Object)("Looking for matches in " + string2 + " for " + string));
                            object = new StringPattern(string);
                            byte[] byArray = null;
                            try {
                                byArray = this.nfs.openDirectory(string2);
                                SftpFile[] sftpFileArray = this.nfs.readDirectory(byArray);
                                for (int i = 0; i < sftpFileArray.length; ++i) {
                                    log.debug((Object)("Testing for match against " + sftpFileArray[i].getFilename()));
                                    if (((StringPattern)object).matches(sftpFileArray[i].getFilename())) {
                                        log.debug((Object)"Matched");
                                        this.writeFileToRemote(string2 + "/" + sftpFileArray[i].getFilename());
                                        continue;
                                    }
                                    log.debug((Object)"No match");
                                }
                            }
                            finally {
                                if (byArray != null) {
                                    try {
                                        this.nfs.closeFile(byArray);
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                        log.debug((Object)"No wildcards");
                        this.writeFileToRemote(this.destination);
                        log.debug((Object)"File transfers complete");
                        break block24;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        log.error((Object)fileNotFoundException);
                        this.writeError(fileNotFoundException.getMessage(), true);
                        throw new IOException(fileNotFoundException.getMessage());
                    }
                    catch (PermissionDeniedException permissionDeniedException) {
                        log.error((Object)permissionDeniedException);
                        this.writeError(permissionDeniedException.getMessage(), true);
                        throw new IOException(permissionDeniedException.getMessage());
                    }
                    catch (InvalidHandleException invalidHandleException) {
                        log.error((Object)invalidHandleException);
                        this.writeError(invalidHandleException.getMessage(), true);
                        throw new IOException(invalidHandleException.getMessage());
                    }
                    catch (IOException iOException) {
                        log.error((Object)iOException);
                        this.writeError(iOException.getMessage(), true);
                        throw new IOException(iOException.getMessage());
                    }
                }
                log.info((Object)"To mode");
                this.readFromRemote(this.destination);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                log.error((Object)throwable);
                this.exitCode = 1;
            }
        }
        log.debug((Object)"ScpServer stopped, notify block on waitForExitCode().");
        object = this;
        synchronized (object) {
            this.notify();
        }
    }

    private boolean writeDirToRemote(String string) throws IOException {
        FileAttributes fileAttributes = this.nfs.getFileAttributes(string);
        if (fileAttributes.isDirectory() && !this.recursive) {
            this.writeError("File " + string + " is a directory, use recursive mode");
            return false;
        }
        String string2 = string;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string2 = string.substring(n + 1);
        }
        this.writeCommand("D" + fileAttributes.getMaskString() + " 0 " + string2 + "\n");
        this.waitForResponse();
        byte[] byArray = null;
        try {
            byArray = this.nfs.openDirectory(string);
            SftpFile[] sftpFileArray = this.nfs.readDirectory(byArray);
            for (int i = 0; i < sftpFileArray.length; ++i) {
                this.writeFileToRemote(string + "/" + sftpFileArray[i].getFilename());
            }
            this.writeCommand("E");
        }
        catch (InvalidHandleException invalidHandleException) {
            throw new IOException(invalidHandleException.getMessage());
        }
        catch (PermissionDeniedException permissionDeniedException) {
            throw new IOException(permissionDeniedException.getMessage());
        }
        finally {
            if (byArray != null) {
                try {
                    this.nfs.closeFile(byArray);
                }
                catch (Exception exception) {
                    log.error((Object)exception);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeFileToRemote(String string) throws IOException, PermissionDeniedException, InvalidHandleException {
        block14: {
            FileAttributes fileAttributes = this.nfs.getFileAttributes(string);
            if (fileAttributes.isDirectory()) {
                if (!this.writeDirToRemote(string)) {
                    return;
                }
            } else {
                if (!fileAttributes.isFile()) throw new IOException(string + " not valid for SCP.");
                String string2 = string;
                int n = string2.lastIndexOf(47);
                if (n != -1) {
                    string2 = string.substring(n + 1);
                }
                this.writeCommand("C" + fileAttributes.getMaskString() + " " + fileAttributes.getSize() + " " + string2 + "\n");
                this.waitForResponse();
                log.debug((Object)("Opening file " + string));
                byte[] byArray = null;
                try {
                    int n2;
                    byte[] byArray2;
                    byArray = this.nfs.openFile(string, new UnsignedInteger32(1L), fileAttributes);
                    log.debug((Object)"Sending file");
                    for (n2 = 0; n2 < fileAttributes.getSize().intValue(); n2 += byArray2.length) {
                        try {
                            byArray2 = this.nfs.readFile(byArray, new UnsignedInteger64(String.valueOf(n2)), new UnsignedInteger32((long)BUFFER_SIZE));
                            log.debug((Object)("Writing block of " + byArray2.length + " bytes"));
                            this.pipeIn.write(byArray2);
                            continue;
                        }
                        catch (EOFException eOFException) {
                            log.debug((Object)"End of file - finishing transfer");
                            break;
                        }
                    }
                    this.pipeIn.flush();
                    if (n2 < fileAttributes.getSize().intValue()) {
                        throw new IOException("File transfer terminated abnormally.");
                    }
                    log.info((Object)"File transfer complete.");
                    this.writeOk();
                    if (byArray == null) break block14;
                }
                catch (Throwable throwable) {
                    if (byArray == null) throw throwable;
                    try {
                        this.nfs.closeFile(byArray);
                        throw throwable;
                    }
                    catch (Exception exception) {
                        log.error((Object)exception);
                    }
                    throw throwable;
                }
                try {
                    this.nfs.closeFile(byArray);
                }
                catch (Exception exception) {
                    log.error((Object)exception);
                }
            }
        }
        this.waitForResponse();
    }

    private void waitForResponse() throws IOException {
        log.debug((Object)"Waiting for response");
        int n = this.pipeOut.read();
        if (n == 0) {
            log.debug((Object)"Got Ok");
            return;
        }
        if (n == -1) {
            throw new EOFException("SCP returned unexpected EOF");
        }
        String string = this.readString();
        log.debug((Object)("Got error '" + string + "'"));
        if (n == 2) {
            log.debug((Object)"This is a serious error");
            throw new IOException(string);
        }
        throw new IOException("SCP returned an unexpected error: " + string);
    }

    private void readFromRemote(String string) throws IOException {
        String string2;
        String[] stringArray = new String[3];
        this.writeOk();
        block27: while (true) {
            log.debug((Object)"Waiting for command");
            try {
                string2 = this.readString();
            }
            catch (EOFException eOFException) {
                return;
            }
            log.debug((Object)("Got command '" + string2 + "'"));
            char c = string2.charAt(0);
            switch (c) {
                case 'E': {
                    this.writeOk();
                    return;
                }
                case 'T': {
                    log.error((Object)"SCP time not currently supported");
                    this.writeError("WARNING: This server does not currently support the SCP time command");
                    continue block27;
                }
                case 'C': 
                case 'D': {
                    Object object;
                    this.parseCommand(string2, stringArray);
                    FileAttributes fileAttributes = null;
                    try {
                        log.debug((Object)("Getting attributes for current destination (" + string + ")"));
                        fileAttributes = this.nfs.getFileAttributes(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        log.debug((Object)"Current destination not found");
                    }
                    String string3 = string;
                    String string4 = stringArray[2];
                    if (fileAttributes != null && fileAttributes.isDirectory()) {
                        log.debug((Object)"Target is a directory");
                        string3 = string3 + '/' + string4;
                    }
                    FileAttributes fileAttributes2 = null;
                    try {
                        log.debug((Object)("Getting attributes for target destination (" + string3 + ")"));
                        fileAttributes2 = this.nfs.getFileAttributes(string3);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        log.debug((Object)"Target destination not found");
                    }
                    if (c == 'D') {
                        log.debug((Object)"Got directory request");
                        if (fileAttributes2 != null) {
                            if (!fileAttributes2.isDirectory()) {
                                object = "Invalid target " + string4 + ", must be a directory";
                                this.writeError((String)object);
                                throw new IOException((String)object);
                            }
                        } else {
                            try {
                                log.debug((Object)("Creating directory " + string3));
                                if (!this.nfs.makeDirectory(string3)) {
                                    object = "Could not create directory: " + string4;
                                    this.writeError((String)object);
                                    throw new IOException((String)object);
                                }
                                log.debug((Object)"Setting permissions on directory");
                                fileAttributes.setPermissionsFromMaskString(stringArray[0]);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                this.writeError("File not found");
                                throw new IOException("File not found");
                            }
                            catch (PermissionDeniedException permissionDeniedException) {
                                this.writeError("Permission denied");
                                throw new IOException("Permission denied");
                            }
                        }
                        this.readFromRemote(string3);
                        continue block27;
                    }
                    log.debug((Object)"Opening file for writing");
                    object = null;
                    try {
                        object = this.nfs.openFile(string3, new UnsignedInteger32(26L), fileAttributes);
                        log.debug((Object)"NFS file opened");
                        this.writeOk();
                        log.debug((Object)"Reading from client");
                        int n = 0;
                        long l = Long.parseLong(stringArray[1]);
                        while ((long)n < l) {
                            int n2 = this.pipeOut.read(this.buffer, 0, (int)(l - (long)n < (long)this.buffer.length ? l - (long)n : (long)this.buffer.length));
                            if (n2 == -1) {
                                throw new EOFException("ScpServer received an unexpected EOF during file transfer");
                            }
                            log.debug((Object)("Got block of " + n2));
                            this.nfs.writeFile((byte[])object, new UnsignedInteger64(String.valueOf(n)), this.buffer, 0, n2);
                            n += n2;
                        }
                        log.debug((Object)"File transfer complete");
                    }
                    catch (InvalidHandleException invalidHandleException) {
                        this.writeError("Invalid handle.");
                        throw new IOException("Invalid handle.");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.writeError("File not found");
                        throw new IOException("File not found");
                    }
                    catch (PermissionDeniedException permissionDeniedException) {
                        this.writeError("Permission denied");
                        throw new IOException("Permission denied");
                    }
                    finally {
                        if (object != null) {
                            try {
                                log.debug((Object)"Closing handle");
                                this.nfs.closeFile((byte[])object);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    this.waitForResponse();
                    if (this.preserveAttributes) {
                        fileAttributes.setPermissionsFromMaskString(stringArray[0]);
                        log.debug((Object)("Setting permissions on directory to " + fileAttributes.getPermissionsString()));
                        try {
                            this.nfs.setFileAttributes(string3, fileAttributes);
                        }
                        catch (Exception exception) {
                            this.writeError("Failed to set file permissions.");
                            continue block27;
                        }
                    }
                    this.writeOk();
                    continue block27;
                }
            }
            break;
        }
        this.writeError("Unexpected cmd: " + string2);
        throw new IOException("SCP unexpected cmd: " + string2);
    }

    private void parseCommand(String string, String[] stringArray) throws IOException {
        int n = string.indexOf(32);
        int n2 = string.indexOf(32, n + 1);
        if (n == -1 || n2 == -1) {
            this.writeError("Syntax error in cmd");
            throw new IOException("Syntax error in cmd");
        }
        stringArray[0] = string.substring(1, n);
        stringArray[1] = string.substring(n + 1, n2);
        stringArray[2] = string.substring(n2 + 1);
    }

    private String readString() throws IOException {
        int n;
        int n2 = 0;
        while ((n = this.pipeOut.read()) != 10 && n >= 0) {
            this.buffer[n2++] = (byte)n;
        }
        if (n == -1) {
            throw new EOFException("SCP returned unexpected EOF");
        }
        if (this.buffer[0] == 10) {
            throw new IOException("Unexpected <NL>");
        }
        if (this.buffer[0] == 2 || this.buffer[0] == 1) {
            String string = new String(this.buffer, 1, n2 - 1);
            if (this.buffer[0] == 2) {
                throw new IOException(string);
            }
            throw new IOException("SCP returned an unexpected error: " + string);
        }
        return new String(this.buffer, 0, n2);
    }
}

