/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.proxy;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public class Proxy {
    private String scheme;
    private String host;
    private int port;
    private String username;
    private String password;

    public static Proxy create(URI uri) {
        Proxy proxy = new Proxy(uri.getHost(), uri.getPort(), uri.getScheme());
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String[] up = userInfo.split(":");
            if (up.length == 1) {
                proxy.username = up[0].isEmpty() ? null : up[0];
            } else {
                proxy.username = up[0].isEmpty() ? null : up[0];
                proxy.password = up[1].isEmpty() ? null : up[1];
            }
        }
        return proxy;
    }

    public Proxy(String host, int port) {
        this(host, port, null);
    }

    public Proxy(String host, int port, String scheme) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
    }

    public Proxy(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public URI toURI() {
        URI uri;
        StringBuilder userInfoBuffer = new StringBuilder();
        if (this.username != null) {
            userInfoBuffer.append(this.urlencode(this.username));
        }
        if (this.password != null) {
            userInfoBuffer.append(":").append(this.urlencode(this.password));
        }
        String userInfo = (String)StringUtils.defaultIfEmpty((CharSequence)userInfoBuffer.toString(), null);
        try {
            uri = new URI(this.scheme, userInfo, this.host, this.port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return uri;
    }

    private String urlencode(String s) {
        String enc = StandardCharsets.UTF_8.name();
        try {
            return URLEncoder.encode(s, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Proxy proxy = (Proxy)o;
        if (this.port != proxy.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(proxy.host) : proxy.host != null) {
            return false;
        }
        if (this.scheme != null ? !this.scheme.equals(proxy.scheme) : proxy.scheme != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(proxy.username) : proxy.username != null) {
            return false;
        }
        return this.password != null ? this.password.equals(proxy.password) : proxy.password == null;
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.toURI().toString();
    }
}

