/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.basic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import wicket.markup.ComponentTag;
import wicket.markup.MarkupStream;
import wicket.markup.html.basic.Label;
import wicket.model.IModel;

public final class SmartLinkLabel
extends Label {
    private static final Pattern emailPattern = Pattern.compile("[\\w\\.-]+@[\\w\\.-]+", 32);
    private static final String emailReplacePattern = "<a href=\"mailto:$0\">$0</a>";
    private static final Pattern urlPattern = Pattern.compile("([a-zA-Z]+://[\\w\\.\\-\\:\\/]+)[\\w\\.:\\-/?&=%]*", 32);
    private static final String urlReplacePattern = "<a href=\"$0\">$1</a>";

    public SmartLinkLabel(String name, String label) {
        super(name, label);
    }

    public SmartLinkLabel(String name, IModel model) {
        super(name, model);
    }

    protected void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        this.replaceComponentTagBody(markupStream, openTag, SmartLinkLabel.smartLink(this.getModelObjectAsString()));
    }

    static String smartLink(String text) {
        if (text == null) {
            return text;
        }
        Matcher matcher = emailPattern.matcher(text);
        String work = matcher.replaceAll(emailReplacePattern);
        matcher = urlPattern.matcher(work);
        work = matcher.replaceAll(urlReplacePattern);
        return work;
    }
}

