/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import wicket.RequestCycle;
import wicket.WicketRuntimeException;
import wicket.extensions.util.encoding.CharSetMap;
import wicket.protocol.http.WebApplication;

public class CharSetUtil {
    private static Log log = LogFactory.getLog((Class)(class$wicket$extensions$util$encoding$CharSetUtil == null ? (class$wicket$extensions$util$encoding$CharSetUtil = CharSetUtil.class$("wicket.extensions.util.encoding.CharSetUtil")) : class$wicket$extensions$util$encoding$CharSetUtil));
    private static CharSetMap charSetMap;
    static /* synthetic */ Class class$wicket$extensions$util$encoding$CharSetUtil;

    private static final synchronized void initialize(WebApplication application) {
        if (charSetMap == null) {
            ServletContext context = application.getWicketServlet().getServletContext();
            InputStream inputStream = context.getResourceAsStream("/WEB-INF/charset.properties");
            if (inputStream == null) {
                charSetMap = new CharSetMap();
                log.debug((Object)"File 'charset.properties' not found");
            } else {
                try {
                    charSetMap = new CharSetMap(inputStream);
                }
                catch (IOException ex) {
                    throw new WicketRuntimeException("Error while reading CharSetMap", (Throwable)ex);
                }
            }
        }
    }

    public static final String getEncoding(RequestCycle cycle) {
        if (charSetMap == null) {
            CharSetUtil.initialize((WebApplication)cycle.getApplication());
        }
        return charSetMap.getCharSet(cycle.getSession().getLocale());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

