/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.beanedit;

import java.beans.IndexedPropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import wicket.AttributeModifier;
import wicket.Component;
import wicket.WicketRuntimeException;
import wicket.extensions.markup.html.beanedit.AbstractBeanPanel;
import wicket.extensions.markup.html.beanedit.BeanModel;
import wicket.extensions.markup.html.beanedit.BeanPropertiesListModel;
import wicket.extensions.markup.html.beanedit.BeanPropertyEditor;
import wicket.extensions.markup.html.beanedit.BeanPropertyModel;
import wicket.extensions.markup.html.beanedit.DefaultBeanHeaderPanel;
import wicket.extensions.markup.html.beanedit.EditMode;
import wicket.extensions.markup.html.beanedit.EditModeReplacementModel;
import wicket.extensions.markup.html.beanedit.IPropertyEditorFactory;
import wicket.extensions.markup.html.beanedit.PropertyMeta;
import wicket.markup.html.basic.Label;
import wicket.markup.html.form.CheckBox;
import wicket.markup.html.form.TextField;
import wicket.markup.html.link.Link;
import wicket.markup.html.list.ListItem;
import wicket.markup.html.list.ListView;
import wicket.markup.html.panel.Panel;
import wicket.model.IModel;

public class BeanPanel
extends AbstractBeanPanel {
    private static final long serialVersionUID = 1L;
    private IPropertyEditorFactory propertyEditorFactory;
    private static final Class[] BOOL_TYPES = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE};
    private static final Class[] BASE_TYPES = new Class[]{class$java$lang$String == null ? (class$java$lang$String = BeanPanel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Number == null ? (class$java$lang$Number = BeanPanel.class$("java.lang.Number")) : class$java$lang$Number, Integer.TYPE, Double.TYPE, Long.TYPE, Float.TYPE, Short.TYPE, Byte.TYPE, class$java$util$Date == null ? (class$java$util$Date = BeanPanel.class$("java.util.Date")) : class$java$util$Date};
    private EditMode editMode = EditMode.READ_WRITE;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$wicket$extensions$markup$html$beanedit$BeanModel;
    static /* synthetic */ Class class$wicket$extensions$markup$html$beanedit$PropertyMeta;
    static /* synthetic */ Class class$wicket$extensions$markup$html$beanedit$EditMode;

    public BeanPanel(String id, Serializable bean) {
        this(id, new BeanModel(bean));
    }

    public BeanPanel(String id, BeanModel beanModel) {
        super(id, beanModel);
        this.setRenderBodyOnly(true);
        Panel header = this.newHeader("header", beanModel);
        if (header == null) {
            throw new NullPointerException("header must be not null");
        }
        this.add((Component)header);
        this.add((Component)new PropertyList("propertiesList", new BeanPropertiesListModel(beanModel)));
    }

    protected Panel newHeader(String panelId, BeanModel beanModel) {
        return new DefaultBeanHeaderPanel(panelId, beanModel);
    }

    protected Panel newPropertyEditor(String panelId, PropertyMeta propertyMeta) {
        Class type = propertyMeta.getPropertyType();
        BeanPropertyEditor editor = this.findCustomEditor(panelId, propertyMeta);
        if (editor == null) {
            if (propertyMeta.getPropertyDescriptor() instanceof IndexedPropertyDescriptor) {
                throw new WicketRuntimeException("indexed properties not supported yet ");
            }
            editor = this.newDefaultEditor(panelId, propertyMeta);
        }
        return editor;
    }

    protected EditMode getEditMode() {
        return this.editMode;
    }

    protected void setEditMode(EditMode editMode) {
        this.editMode = editMode;
    }

    protected final BeanPropertyEditor newDefaultEditor(String panelId, PropertyMeta propertyMeta) {
        BeanPropertyEditor editor;
        Class type = propertyMeta.getPropertyType();
        if (this.checkAssignableFrom(BOOL_TYPES, type)) {
            editor = new PropertyCheckBox(panelId, propertyMeta);
        }
        if (!this.checkAssignableFrom(BASE_TYPES, type)) {
            return new ButtonToMoreDetails(panelId, propertyMeta);
        }
        editor = new PropertyInput(panelId, propertyMeta);
        return editor;
    }

    private boolean checkAssignableFrom(Class[] types, Class type) {
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            if (!types[i].isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    protected final BeanPropertyEditor findCustomEditor(String panelId, PropertyMeta propertyMeta) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        Class type = propertyMeta.getPropertyType();
        String editorTypeName = type.getName() + "Editor";
        try {
            Class<?> editorClass = classLoader.loadClass(editorTypeName);
            try {
                Constructor<?> constructor = editorClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BeanPanel.class$("java.lang.String")) : class$java$lang$String, class$wicket$extensions$markup$html$beanedit$BeanModel == null ? (class$wicket$extensions$markup$html$beanedit$BeanModel = BeanPanel.class$("wicket.extensions.markup.html.beanedit.BeanModel")) : class$wicket$extensions$markup$html$beanedit$BeanModel, class$wicket$extensions$markup$html$beanedit$PropertyMeta == null ? (class$wicket$extensions$markup$html$beanedit$PropertyMeta = BeanPanel.class$("wicket.extensions.markup.html.beanedit.PropertyMeta")) : class$wicket$extensions$markup$html$beanedit$PropertyMeta, class$wicket$extensions$markup$html$beanedit$EditMode == null ? (class$wicket$extensions$markup$html$beanedit$EditMode = BeanPanel.class$("wicket.extensions.markup.html.beanedit.EditMode")) : class$wicket$extensions$markup$html$beanedit$EditMode);
                Object[] args = new Object[]{panelId, this.getModel(), propertyMeta, this.getEditMode()};
                BeanPropertyEditor editor = (BeanPropertyEditor)((Object)constructor.newInstance(args));
                return editor;
            }
            catch (SecurityException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class ButtonToMoreDetails
    extends BeanPropertyEditor {
        private static final long serialVersionUID = 1L;

        public ButtonToMoreDetails(String id, PropertyMeta propertyMeta) {
            super(id, propertyMeta);
            this.add((Component)new Link(this, "button"){
                private static final long serialVersionUID = 1L;
                private final /* synthetic */ ButtonToMoreDetails this$0;
                {
                    this.this$0 = this$0;
                }

                public void onClick() {
                }
            });
        }
    }

    static final class PropertyCheckBox
    extends BeanPropertyEditor {
        private static final long serialVersionUID = 1L;

        public PropertyCheckBox(String id, PropertyMeta propertyMeta) {
            super(id, propertyMeta);
            this.setRenderBodyOnly(true);
            Class type = propertyMeta.getPropertyType();
            CheckBox valueTextField = new CheckBox("value", (IModel)new BeanPropertyModel(propertyMeta));
            EditModeReplacementModel replacementModel = new EditModeReplacementModel(propertyMeta);
            valueTextField.add(new AttributeModifier("disabled", true, (IModel)replacementModel));
            this.add((Component)valueTextField);
        }
    }

    static final class PropertyInput
    extends BeanPropertyEditor {
        private static final long serialVersionUID = 1L;

        public PropertyInput(String id, PropertyMeta propertyMeta) {
            super(id, propertyMeta);
            this.setRenderBodyOnly(true);
            Class type = propertyMeta.getPropertyType();
            TextField valueTextField = new TextField("value", (IModel)new BeanPropertyModel(propertyMeta), type);
            EditModeReplacementModel replacementModel = new EditModeReplacementModel(propertyMeta);
            valueTextField.add(new AttributeModifier("disabled", true, (IModel)replacementModel));
            this.add((Component)valueTextField);
        }
    }

    private final class PropertyList
    extends ListView {
        private static final long serialVersionUID = 1L;

        public PropertyList(String id, BeanPropertiesListModel model) {
            super(id, (IModel)model);
            this.setOptimizeItemRemoval(true);
        }

        protected void populateItem(ListItem item) {
            PropertyMeta propertyMeta = (PropertyMeta)item.getModelObject();
            item.add((Component)new Label("displayName", propertyMeta.getDisplayName()));
            Panel propertyEditor = BeanPanel.this.newPropertyEditor("editor", propertyMeta);
            if (propertyEditor == null) {
                throw new NullPointerException("propertyEditor must be not null");
            }
            item.add((Component)propertyEditor);
        }
    }
}

