/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.beanedit;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import wicket.Component;
import wicket.extensions.markup.html.beanedit.BeanModel;
import wicket.extensions.markup.html.beanedit.PropertyMeta;
import wicket.model.Model;

public final class BeanPropertiesListModel
extends Model {
    private static final long serialVersionUID = 1L;
    private final BeanModel beanModel;

    public BeanPropertiesListModel(BeanModel beanModel) {
        this.beanModel = beanModel;
    }

    public Object getObject(Component component) {
        PropertyDescriptor[] descriptors;
        BeanInfo beanInfo = this.beanModel.getBeanInfo(component);
        if (beanInfo != null && (descriptors = beanInfo.getPropertyDescriptors()) != null) {
            ArrayList<PropertyMeta> all = new ArrayList<PropertyMeta>();
            int len = descriptors.length;
            for (int i = 0; i < len; ++i) {
                if (!this.shouldAdd(descriptors[i])) continue;
                PropertyMeta meta = new PropertyMeta(this.beanModel, descriptors[i]);
                all.add(meta);
            }
            int defaultPropertyIndex = beanInfo.getDefaultPropertyIndex();
            if (defaultPropertyIndex != -1) {
                // empty if block
            }
            return all;
        }
        return Collections.EMPTY_LIST;
    }

    public void setObject(Component component, Object object) {
        throw new UnsupportedOperationException("this model is read only");
    }

    private boolean shouldAdd(PropertyDescriptor descriptor) {
        return !"class".equals(descriptor.getName());
    }
}

