/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.beanedit;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import wicket.Component;
import wicket.WicketRuntimeException;
import wicket.extensions.markup.html.beanedit.PropertyMeta;
import wicket.model.IModel;

public class BeanPropertyModel
implements IModel {
    private static final long serialVersionUID = 1L;
    private final PropertyMeta propertyMeta;

    public BeanPropertyModel(PropertyMeta propertyMeta) {
        this.propertyMeta = propertyMeta;
    }

    public Object getObject(Component component) {
        Method method = this.propertyMeta.getPropertyDescriptor().getReadMethod();
        if (method != null) {
            Serializable bean = this.propertyMeta.getBeanModel().getBean();
            try {
                Object value = method.invoke((Object)bean, null);
                return value;
            }
            catch (IllegalAccessException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    public void setObject(Component component, Object object) {
        Method method = this.propertyMeta.getPropertyDescriptor().getWriteMethod();
        if (method != null) {
            Serializable bean = this.propertyMeta.getBeanModel().getBean();
            try {
                method.invoke((Object)bean, object);
            }
            catch (IllegalAccessException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
    }

    public IModel getNestedModel() {
        return null;
    }

    public void detach() {
    }
}

