/*
 * Decompiled with CFR 0.152.
 */
package wicket.extensions.markup.html.image.resource;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import wicket.WicketRuntimeException;
import wicket.markup.html.WebResource;
import wicket.markup.html.image.resource.DynamicImageResource;
import wicket.util.resource.ResourceStreamNotFoundException;
import wicket.util.time.Time;

public class ThumbnailImageResource
extends DynamicImageResource {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog((Class)(class$wicket$extensions$markup$html$image$resource$ThumbnailImageResource == null ? (class$wicket$extensions$markup$html$image$resource$ThumbnailImageResource = ThumbnailImageResource.class$("wicket.extensions.markup.html.image.resource.ThumbnailImageResource")) : class$wicket$extensions$markup$html$image$resource$ThumbnailImageResource));
    private final WebResource unscaledImageResource;
    private final int maxSize;
    private int scaleHints = 4;
    private transient byte[] thumbnail;
    static /* synthetic */ Class class$wicket$extensions$markup$html$image$resource$ThumbnailImageResource;

    public ThumbnailImageResource(WebResource unscaledImageResource, int maxSize) {
        if (unscaledImageResource == null) {
            throw new NullPointerException("unscaledImageResource must be not null");
        }
        this.unscaledImageResource = unscaledImageResource;
        this.maxSize = maxSize;
    }

    protected byte[] getImageData() {
        if (this.thumbnail == null) {
            BufferedImage image = this.getScaledImageInstance();
            this.thumbnail = this.toImageData(image);
            this.setLastModifiedTime(Time.now());
        }
        return this.thumbnail;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final BufferedImage getScaledImageInstance() {
        block12: {
            is = null;
            originalImage = null;
            try {
                is = this.unscaledImageResource.getResourceStream().getInputStream();
                originalImage = ImageIO.read(is);
                if (originalImage == null) {
                    throw new IOException("unable to read image");
                }
                var5_3 = null;
                if (is == null) break block12;
                ** GOTO lbl26
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            catch (ResourceStreamNotFoundException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            {
                catch (Throwable var4_12) {
                    var5_4 = null;
                    if (is == null) throw var4_12;
                    try {
                        is.close();
                        throw var4_12;
                    }
                    catch (IOException e) {
                        ThumbnailImageResource.log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    throw var4_12;
                }
lbl26:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [4 : 76->83)] { 
lbl27:
                // 1 sources

                is.close();
lbl29:
                // 1 sources

                catch (IOException e) {}
                ThumbnailImageResource.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        originalWidth = originalImage.getWidth();
        originalHeight = originalImage.getHeight();
        if (originalWidth <= this.maxSize) {
            if (originalHeight <= this.maxSize) return originalImage;
        }
        if (originalWidth > originalHeight) {
            newWidth = this.maxSize;
            newHeight = this.maxSize * originalHeight / originalWidth;
        } else {
            newWidth = this.maxSize * originalWidth / originalHeight;
            newHeight = this.maxSize;
        }
        image = originalImage.getScaledInstance(newWidth, newHeight, this.scaleHints);
        bufferedImage = new BufferedImage(newWidth, newHeight, 4);
        bufferedImage.createGraphics().drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public final void setScaleHints(int scaleHints) {
        this.scaleHints = scaleHints;
        this.thumbnail = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

