/*
 * Decompiled with CFR 0.152.
 */
package wicket.spring.injection.annot;

import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import wicket.injection.IFieldValueFactory;
import wicket.proxy.IProxyTargetLocator;
import wicket.proxy.LazyInitProxyFactory;
import wicket.spring.ISpringContextLocator;
import wicket.spring.SpringBeanLocator;
import wicket.spring.injection.annot.SpringBean;

public class AnnotProxyFieldValueFactory
implements IFieldValueFactory {
    private ISpringContextLocator contextLocator;
    private final ConcurrentHashMap<SpringBeanLocator, Object> cache = new ConcurrentHashMap();

    public AnnotProxyFieldValueFactory(ISpringContextLocator contextLocator) {
        if (contextLocator == null) {
            throw new IllegalArgumentException("[contextLocator] argument cannot be null");
        }
        this.contextLocator = contextLocator;
    }

    public Object getFieldValue(Field field, Object fieldOwner) {
        if (field.isAnnotationPresent(SpringBean.class)) {
            SpringBean annot = field.getAnnotation(SpringBean.class);
            SpringBeanLocator locator = new SpringBeanLocator(annot.name(), field.getType(), this.contextLocator);
            if (this.cache.containsKey(locator)) {
                return this.cache.get(locator);
            }
            this.testLocator(locator, fieldOwner, field);
            Object proxy = LazyInitProxyFactory.createProxy(field.getType(), (IProxyTargetLocator)locator);
            this.cache.put(locator, proxy);
            return proxy;
        }
        return null;
    }

    private void testLocator(SpringBeanLocator locator, Object fieldOwner, Field field) {
        try {
            locator.locateProxyTarget();
        }
        catch (Throwable e) {
            String errorMessage = "Could not locate spring bean of class [[" + locator.getBeanType().getName() + "]] ";
            if (locator.getBeanName() != null && locator.getBeanName().length() > 0) {
                errorMessage = errorMessage + "and id [[" + locator.getBeanName() + "]] ";
            }
            errorMessage = errorMessage + "needed in class [[" + fieldOwner.getClass().getName() + "]] field [[" + field.getName() + "]]";
            throw new RuntimeException(errorMessage, e);
        }
    }

    public boolean supportsField(Field field) {
        return field.isAnnotationPresent(SpringBean.class);
    }
}

