/*
 * Decompiled with CFR 0.152.
 */
package wicket.spring.injection.annot;

import java.io.FileNotFoundException;
import java.io.Serializable;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ResourceUtils;
import org.springframework.web.context.support.WebApplicationContextUtils;
import wicket.Application;
import wicket.MetaDataKey;
import wicket.injection.ComponentInjector;
import wicket.injection.ConfigurableInjector;
import wicket.injection.web.InjectorHolder;
import wicket.protocol.http.WebApplication;
import wicket.protocol.http.portlet.PortletApplication;
import wicket.spring.ISpringContextLocator;
import wicket.spring.injection.annot.AnnotSpringInjector;

public class SpringComponentInjector
extends ComponentInjector {
    private static MetaDataKey CONTEXT_KEY = new MetaDataKey(ApplicationContextHolder.class){
        private static final long serialVersionUID = 1L;
    };

    public SpringComponentInjector(WebApplication webapp) {
        this(webapp, (ApplicationContext)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)webapp.getWicketServlet().getServletContext()));
    }

    public SpringComponentInjector(WebApplication webapp, ApplicationContext ctx) {
        if (webapp == null) {
            throw new IllegalArgumentException("Argument [[webapp]] cannot be null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("Argument [[ctx]] cannot be null");
        }
        webapp.setMetaData(CONTEXT_KEY, (Serializable)new ApplicationContextHolder(ctx));
        InjectorHolder.setInjector((ConfigurableInjector)new AnnotSpringInjector(new ContextLocator()));
    }

    public SpringComponentInjector(PortletApplication portletapp) {
        GenericApplicationContext ctx = new GenericApplicationContext();
        String configLocation = portletapp.getWicketPortlet().getInitParameter("contextConfigLocation");
        UrlResource resource = null;
        try {
            resource = new UrlResource(ResourceUtils.getURL((String)configLocation));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
        new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx).loadBeanDefinitions((Resource)resource);
        ctx.refresh();
        portletapp.setMetaData(CONTEXT_KEY, (Serializable)new ApplicationContextHolder((ApplicationContext)ctx));
        InjectorHolder.setInjector((ConfigurableInjector)new AnnotSpringInjector(new ContextLocator()));
    }

    private static class ContextLocator
    implements ISpringContextLocator {
        private transient ApplicationContext context;
        private static final long serialVersionUID = 1L;

        private ContextLocator() {
        }

        public ApplicationContext getSpringContext() {
            if (this.context == null) {
                this.context = ((ApplicationContextHolder)Application.get().getMetaData(CONTEXT_KEY)).getContext();
            }
            return this.context;
        }
    }

    private static class ApplicationContextHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ApplicationContext context;

        public ApplicationContextHolder(ApplicationContext context) {
            this.context = context;
        }

        public ApplicationContext getContext() {
            return this.context;
        }
    }
}

