/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.generama.JellyTemplateEngine;
import org.generama.MetadataProvider;
import org.generama.OutputValidator;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.WriterMapper;
import org.generama.defaults.XMLOutputValidator;
import org.xdoclet.plugin.hibernate.AbstractHibernatePlugin;
import org.xdoclet.plugin.hibernate.HibernateProperty;
import org.xdoclet.plugin.hibernate.qtags.HibernateFilterParamTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateTypedefParamTag;
import org.xdoclet.plugin.hibernate.qtags.TagLibrary;

public class HibernateMappingPlugin
extends AbstractHibernatePlugin {
    static final String TAG_PREFIX = "hibernate.";
    static final Log log = LogFactory.getLog((Class)(class$org$xdoclet$plugin$hibernate$HibernateMappingPlugin == null ? (class$org$xdoclet$plugin$hibernate$HibernateMappingPlugin = HibernateMappingPlugin.class$("org.xdoclet.plugin.hibernate.HibernateMappingPlugin")) : class$org$xdoclet$plugin$hibernate$HibernateMappingPlugin));
    static final Map tagDispatch = new HashMap();
    static final List PROPERTY_TAGS = new ArrayList();
    static final List ALLOWED_IN_PROPERTIES_TAGS = new ArrayList();
    static final List HIERARCHY_STOP_TAGS = new ArrayList();
    static final List ID_TAGS = new ArrayList();
    static final List VERSION_TAGS = new ArrayList();
    private boolean force = false;
    private Stack componentsPrefixies = new Stack();
    static /* synthetic */ Class class$org$xdoclet$plugin$hibernate$HibernateMappingPlugin;

    public HibernateMappingPlugin(JellyTemplateEngine jellyTemplateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super(jellyTemplateEngine, metadataProvider, writerMapper);
        this.setFileregex("\\.java");
        this.setFilereplace("\\.hbm.xml");
        this.setMultioutput(true);
        HashMap<String, URL> dtds = new HashMap<String, URL>();
        dtds.put("http://hibernate.sourceforge.net/hibernate-mapping-2.0.dtd", ((Object)((Object)this)).getClass().getResource("dtd/hibernate-mapping-2.0.dtd"));
        dtds.put("http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd", ((Object)((Object)this)).getClass().getResource("dtd/hibernate-mapping-3.0.dtd"));
        this.setOutputValidator((OutputValidator)new XMLOutputValidator(dtds));
        new TagLibrary((MetadataProvider)metadataProvider);
    }

    public List getAlternateKeyProperties(JavaClass clazz, final String propertiesName) {
        if (propertiesName == null) {
            return null;
        }
        ArrayList retval = new ArrayList();
        this.accumulatePropertiesRecursive(clazz, null, true, ALLOWED_IN_PROPERTIES_TAGS, retval);
        CollectionUtils.filter(retval, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                HibernateProperty prop = (HibernateProperty)object;
                DocletTag tag = HibernateMappingPlugin.this.getTagByNameList(prop.getEntity(), ALLOWED_IN_PROPERTIES_TAGS);
                if (tag == null) {
                    return false;
                }
                return propertiesName.equalsIgnoreCase(tag.getNamedParameter("properties-name"));
            }
        });
        return retval;
    }

    public DocletTag getTagByNameList(AbstractJavaEntity entity, List tagNames) {
        for (int i = 0; i < tagNames.size(); ++i) {
            String tag = (String)tagNames.get(i);
            DocletTag docletTag = entity.getTagByName(tag);
            if (docletTag == null) continue;
            return docletTag;
        }
        return null;
    }

    public List getClassId(JavaClass clazz) {
        ArrayList retval = new ArrayList();
        this.accumulatePropertiesRecursive(clazz, null, true, ID_TAGS, retval);
        return retval;
    }

    public List getClassProperties(JavaClass clazz) {
        ArrayList retval = new ArrayList();
        this.accumulatePropertiesRecursive(clazz, null, true, PROPERTY_TAGS, retval);
        return retval;
    }

    public List getComponentProperties(String componentClassName, JavaClass componentPropertyClass) {
        JavaClass componentClass = componentClassName != null ? this.getMetadata(componentClassName) : componentPropertyClass;
        return this.getClassProperties(componentClass);
    }

    public String getFirstNonEmptyValue(String value1, String value2) {
        return value1 != null && value1.trim().length() > 0 ? value1 : value2;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public JavaClass getMetadata(final String className) {
        if (className == null) {
            throw new NullPointerException("Classname can't be null");
        }
        JavaClass javaClass = (JavaClass)CollectionUtils.find((Collection)this.getMetadata(), (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                JavaClass cl = (JavaClass)o;
                return cl.getFullyQualifiedName().equals(className);
            }
        });
        if (javaClass == null) {
            log.error((Object)("Sourcecode for class '" + className + "' not found by metadata povider"));
            throw new IllegalArgumentException("Class metadata for " + className + " not found");
        }
        return javaClass;
    }

    public String getPropertyName(AbstractJavaEntity metadata) {
        if (metadata instanceof JavaMethod) {
            return ((JavaMethod)metadata).getPropertyName();
        }
        if (metadata instanceof JavaField) {
            return metadata.getName();
        }
        return null;
    }

    public List getPropertyTagList() {
        return PROPERTY_TAGS;
    }

    public List getTagListAllowedInProperties() {
        return ALLOWED_IN_PROPERTIES_TAGS;
    }

    public List getSubclassProperties(JavaClass clazz) {
        ArrayList retval = new ArrayList();
        this.accumulatePropertiesRecursive(clazz, HIERARCHY_STOP_TAGS, true, PROPERTY_TAGS, retval);
        return retval;
    }

    public List getSubclasses(JavaClass clazz, String tagName) {
        ArrayList result = new ArrayList();
        this.getSubclassesWithTagRecursive(result, clazz, tagName);
        Collections.sort(result);
        return result;
    }

    public List getTags(AbstractJavaEntity metadata, Collection tagNames) {
        ArrayList<DocletTag> al = new ArrayList<DocletTag>();
        Iterator iter = tagNames.iterator();
        while (iter.hasNext()) {
            al.addAll(Arrays.asList(metadata.getTagsByName((String)iter.next())));
        }
        return al;
    }

    public List getTags(AbstractJavaEntity metadata, String tagNames) {
        return this.getTags(metadata, Arrays.asList(tagNames.split("\\|")));
    }

    public Collection getTypedefParams(JavaClass clazz, final String typedefName) {
        if (typedefName == null) {
            return null;
        }
        ArrayList<DocletTag> typedefTags = new ArrayList<DocletTag>();
        typedefTags.addAll(Arrays.asList(clazz.getTagsByName("hibernate.typedef-param")));
        CollectionUtils.filter(typedefTags, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                HibernateTypedefParamTag tag = (HibernateTypedefParamTag)object;
                return typedefName.equals(tag.getTypedefName());
            }
        });
        return typedefTags;
    }

    public Collection getFilterdefParams(JavaClass clazz, final String filterdefName) {
        if (filterdefName == null) {
            return null;
        }
        ArrayList<DocletTag> filterdefTags = new ArrayList<DocletTag>();
        filterdefTags.addAll(Arrays.asList(clazz.getTagsByName("hibernate.filter-param")));
        CollectionUtils.filter(filterdefTags, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                HibernateFilterParamTag tag = (HibernateFilterParamTag)object;
                return filterdefName.equals(tag.getFilterdefName());
            }
        });
        return filterdefTags;
    }

    public List getVersionOrTimestamp(JavaClass clazz) {
        ArrayList retval = new ArrayList();
        this.accumulatePropertiesRecursive(clazz, null, true, VERSION_TAGS, retval);
        return retval;
    }

    public String dispatchTag(String tagName) {
        String retval = (String)tagDispatch.get(tagName);
        if (retval == null) {
            if (!tagName.startsWith(TAG_PREFIX)) {
                return null;
            }
            String[] nameParts = tagName.substring(TAG_PREFIX.length()).split("-");
            StringBuffer scriptName = new StringBuffer("/");
            for (int i = 0; i < nameParts.length; ++i) {
                scriptName.append(Character.toUpperCase(nameParts[i].charAt(0)));
                scriptName.append(nameParts[i].substring(1));
            }
            scriptName.append(".jelly");
            retval = scriptName.toString();
            log.debug((Object)("Dispatch tag " + tagName + " to script " + retval));
            tagDispatch.put(tagName, retval);
        }
        return retval;
    }

    public boolean hasAtLeastOne(AbstractJavaEntity metadata, Collection tags) {
        return this.getTags(metadata, tags).size() >= 1;
    }

    public boolean hasAtMostOne(AbstractJavaEntity metadata, Collection tags) {
        return this.getTags(metadata, tags).size() <= 1;
    }

    public boolean hasOnlyOne(AbstractJavaEntity metadata, Collection tags) {
        return this.getTags(metadata, tags).size() == 1;
    }

    public boolean shouldGenerate(Object metadata) {
        boolean generate;
        JavaClass clazz = (JavaClass)metadata;
        if (!this.force) {
            String packagePath = this.getDestinationPackage(metadata).replace('.', '/');
            File dir = new File(this.getDestdirFile(), packagePath);
            String filename = this.getDestinationFilename(metadata);
            File destFile = new File(dir, filename);
            File sourceFile = new File(clazz.getSource().getURL().getFile());
            if (destFile.exists() && sourceFile.lastModified() < destFile.lastModified()) {
                return false;
            }
        }
        boolean bl = generate = clazz.getTagByName("hibernate.class") != null;
        if (generate) {
            System.out.println("  * Generate mapping for '" + clazz.getName() + "' entity");
        }
        return generate;
    }

    private void accumulateProperties(JavaClass clazz, Collection requieredTags, List accumulate) {
        HibernateProperty property;
        BeanProperty[] beanProperties = clazz.getBeanProperties();
        for (int i = 0; i < beanProperties.length; ++i) {
            if (beanProperties[i] == null || beanProperties[i].getAccessor() == null || this.getTags((AbstractJavaEntity)beanProperties[i].getAccessor(), requieredTags).isEmpty()) continue;
            property = new HibernateProperty();
            property.setName(beanProperties[i].getName());
            property.setEntity((AbstractJavaEntity)beanProperties[i].getAccessor());
            if (accumulate.contains(property)) continue;
            accumulate.add(property);
        }
        JavaField[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (this.getTags((AbstractJavaEntity)fields[i], requieredTags).isEmpty()) continue;
            property = new HibernateProperty();
            property.setName(fields[i].getName());
            property.setEntity((AbstractJavaEntity)fields[i]);
            property.setAccess("field");
            if (accumulate.contains(property)) continue;
            accumulate.add(property);
        }
    }

    private void accumulatePropertiesRecursive(JavaClass clazz, Collection stopTags, boolean skipStopTags, Collection requiredTags, List accumulate) {
        if (!skipStopTags && stopTags != null && !this.getTags((AbstractJavaEntity)clazz, stopTags).isEmpty()) {
            return;
        }
        this.accumulateProperties(clazz, requiredTags, accumulate);
        JavaClass superclass = clazz.getSuperJavaClass();
        if (superclass != null) {
            this.accumulatePropertiesRecursive(superclass, stopTags, false, requiredTags, accumulate);
        }
        JavaClass[] ifaces = clazz.getImplementedInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            this.accumulatePropertiesRecursive(ifaces[i], stopTags, false, requiredTags, accumulate);
        }
    }

    private void getSubclassesWithTagRecursive(List found, JavaClass clazz, String tagName) {
        JavaClass[] subclasses = clazz.getDerivedClasses();
        for (int i = 0; i < subclasses.length; ++i) {
            if (subclasses[i].getSuperJavaClass() != clazz && !Arrays.asList(subclasses[i].getImplementedInterfaces()).contains(clazz)) continue;
            if (subclasses[i].getTagByName(tagName) != null) {
                found.add(subclasses[i]);
                continue;
            }
            this.getSubclassesWithTagRecursive(found, subclasses[i], tagName);
        }
    }

    public void startComponent(String prefix) {
        this.componentsPrefixies.push(prefix);
    }

    public void endComponent() {
        this.componentsPrefixies.pop();
    }

    public String buildComponentColumnName(String columnName) {
        if (columnName == null) {
            return null;
        }
        if (this.componentsPrefixies.isEmpty()) {
            return columnName;
        }
        StringBuffer result = new StringBuffer();
        Iterator iterator = this.componentsPrefixies.iterator();
        while (iterator.hasNext()) {
            String pr = (String)iterator.next();
            if (pr == null) continue;
            result.append(pr);
        }
        result.append(columnName);
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PROPERTY_TAGS.add("hibernate.property");
        PROPERTY_TAGS.add("hibernate.many-to-one");
        PROPERTY_TAGS.add("hibernate.one-to-one");
        PROPERTY_TAGS.add("hibernate.component");
        PROPERTY_TAGS.add("hibernate.dynamic-component");
        PROPERTY_TAGS.add("hibernate.any");
        PROPERTY_TAGS.add("hibernate.map");
        PROPERTY_TAGS.add("hibernate.set");
        PROPERTY_TAGS.add("hibernate.list");
        PROPERTY_TAGS.add("hibernate.bag");
        PROPERTY_TAGS.add("hibernate.idbag");
        PROPERTY_TAGS.add("hibernate.array");
        PROPERTY_TAGS.add("hibernate.primitive-array");
        PROPERTY_TAGS.add("hibernate.key-property");
        PROPERTY_TAGS.add("hibernate.key-many-to-one");
        PROPERTY_TAGS.add("hibernate.parent");
        HIERARCHY_STOP_TAGS.add("hibernate.class");
        HIERARCHY_STOP_TAGS.add("hibernate.subclass");
        HIERARCHY_STOP_TAGS.add("hibernate.joined-subclass");
        HIERARCHY_STOP_TAGS.add("hibernate.union-subclass");
        ID_TAGS.add("hibernate.id");
        ID_TAGS.add("hibernate.composite-id");
        VERSION_TAGS.add("hibernate.version");
        VERSION_TAGS.add("hibernate.timestamp");
        ALLOWED_IN_PROPERTIES_TAGS.add("hibernate.property");
        ALLOWED_IN_PROPERTIES_TAGS.add("hibernate.many-to-one");
        ALLOWED_IN_PROPERTIES_TAGS.add("hibernate.component");
        ALLOWED_IN_PROPERTIES_TAGS.add("hibernate.dynamic-component");
    }
}

