/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateAnyTag;

public class HibernateAnyTagImpl
extends XDocletTag
implements HibernateAnyTag {
    public static final String NAME = "hibernate.any";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("optimistic-lock", "index", "lazy", "cascade", "insert", "access", "node", "meta-type", "id-type", "update", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateAnyTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public Boolean getOptimisticLock() {
        boolean required = false;
        String result = this.getNamedParameter("optimistic-lock");
        if (required && result == null) {
            this.bomb("optimistic-lock=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getIndex() {
        boolean required = false;
        String result = this.getNamedParameter("index");
        if (required && result == null) {
            this.bomb("index=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getLazy() {
        boolean required = false;
        String result = this.getNamedParameter("lazy");
        if (required && result == null) {
            this.bomb("lazy=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getCascade() {
        boolean required = false;
        String result = this.getNamedParameter("cascade");
        if (required && result == null) {
            this.bomb("cascade=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getInsert() {
        boolean required = false;
        String result = this.getNamedParameter("insert");
        if (required && result == null) {
            this.bomb("insert=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getAccess() {
        boolean required = false;
        String result = this.getNamedParameter("access");
        if (required && result == null) {
            this.bomb("access=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getNode() {
        boolean required = false;
        String result = this.getNamedParameter("node");
        if (required && result == null) {
            this.bomb("node=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getMetaType() {
        boolean required = false;
        String result = this.getNamedParameter("meta-type");
        if (required && result == null) {
            this.bomb("meta-type=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getIdType() {
        boolean required = true;
        String result = this.getNamedParameter("id-type");
        if (required && result == null) {
            this.bomb("id-type=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getUpdate() {
        boolean required = false;
        String result = this.getNamedParameter("update");
        if (required && result == null) {
            this.bomb("update=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnClass) {
            this.bomb("is not allowed on classes");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.getContext().getTagsByName(NAME).length > 1) {
            this.bomb("is allowed only once");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getOptimisticLock();
        this.getIndex();
        this.getLazy();
        this.getCascade();
        this.getInsert();
        this.getAccess();
        this.getNode();
        this.getMetaType();
        this.getIdType();
        this.getUpdate();
    }
}

