/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateClassTag;

public class HibernateClassTagImpl
extends XDocletTag
implements HibernateClassTag {
    public static final String NAME = "hibernate.class";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("mutable", "optimistic-lock", "polymorphism", "check", "catalog", "comment", "batch-size", "discriminator-value", "dynamic-insert", "dynamic-update", "schema", "rowid", "table", "abstract", "where", "subselect", "lazy", "node", "persister", "select-before-update", "name", "entity-name", "proxy", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateClassTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public Boolean getMutable() {
        boolean required = false;
        String result = this.getNamedParameter("mutable");
        if (required && result == null) {
            this.bomb("mutable=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getOptimisticLock() {
        boolean required = false;
        String result = this.getNamedParameter("optimistic-lock");
        if (required && result == null) {
            this.bomb("optimistic-lock=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            if (!(result.equals("none") || result.equals("dirty") || result.equals("version") || result.equals("all"))) {
                this.bomb("optimistic-lock=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public String getPolymorphism() {
        boolean required = false;
        String result = this.getNamedParameter("polymorphism");
        if (required && result == null) {
            this.bomb("polymorphism=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            if (!result.equals("explicit") && !result.equals("implicit")) {
                this.bomb("polymorphism=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public String getCheck() {
        boolean required = false;
        String result = this.getNamedParameter("check");
        if (required && result == null) {
            this.bomb("check=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getCatalog() {
        boolean required = false;
        String result = this.getNamedParameter("catalog");
        if (required && result == null) {
            this.bomb("catalog=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getComment() {
        boolean required = false;
        String result = this.getNamedParameter("comment");
        if (required && result == null) {
            this.bomb("comment=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getBatchSize() {
        boolean required = false;
        String result = this.getNamedParameter("batch-size");
        if (required && result == null) {
            this.bomb("batch-size=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getDiscriminatorValue() {
        boolean required = false;
        String result = this.getNamedParameter("discriminator-value");
        if (required && result == null) {
            this.bomb("discriminator-value=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getDynamicInsert() {
        boolean required = false;
        String result = this.getNamedParameter("dynamic-insert");
        if (required && result == null) {
            this.bomb("dynamic-insert=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public Boolean getDynamicUpdate() {
        boolean required = false;
        String result = this.getNamedParameter("dynamic-update");
        if (required && result == null) {
            this.bomb("dynamic-update=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getSchema() {
        boolean required = false;
        String result = this.getNamedParameter("schema");
        if (required && result == null) {
            this.bomb("schema=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getRowid() {
        boolean required = false;
        String result = this.getNamedParameter("rowid");
        if (required && result == null) {
            this.bomb("rowid=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getTable() {
        boolean required = false;
        String result = this.getNamedParameter("table");
        if (required && result == null) {
            this.bomb("table=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getAbstract() {
        boolean required = false;
        String result = this.getNamedParameter("abstract");
        if (required && result == null) {
            this.bomb("abstract=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getWhere() {
        boolean required = false;
        String result = this.getNamedParameter("where");
        if (required && result == null) {
            this.bomb("where=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getSubselect() {
        boolean required = false;
        String result = this.getNamedParameter("subselect");
        if (required && result == null) {
            this.bomb("subselect=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getLazy() {
        boolean required = false;
        String result = this.getNamedParameter("lazy");
        if (required && result == null) {
            this.bomb("lazy=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getNode() {
        boolean required = false;
        String result = this.getNamedParameter("node");
        if (required && result == null) {
            this.bomb("node=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getPersister() {
        boolean required = false;
        String result = this.getNamedParameter("persister");
        if (required && result == null) {
            this.bomb("persister=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getSelectBeforeUpdate() {
        boolean required = false;
        String result = this.getNamedParameter("select-before-update");
        if (required && result == null) {
            this.bomb("select-before-update=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getName_() {
        boolean required = false;
        String result = this.getNamedParameter("name");
        if (required && result == null) {
            this.bomb("name=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getEntityName() {
        boolean required = false;
        String result = this.getNamedParameter("entity-name");
        if (required && result == null) {
            this.bomb("entity-name=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getProxy() {
        boolean required = false;
        String result = this.getNamedParameter("proxy");
        if (required && result == null) {
            this.bomb("proxy=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnField) {
            this.bomb("is not allowed on fields");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.isOnMethod) {
            this.bomb("is not allowed on methods");
        }
        if (this.getContext().getTagsByName(NAME).length > 1) {
            this.bomb("is allowed only once");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getMutable();
        this.getOptimisticLock();
        this.getPolymorphism();
        this.getCheck();
        this.getCatalog();
        this.getComment();
        this.getBatchSize();
        this.getDiscriminatorValue();
        this.getDynamicInsert();
        this.getDynamicUpdate();
        this.getSchema();
        this.getRowid();
        this.getTable();
        this.getAbstract();
        this.getWhere();
        this.getSubselect();
        this.getLazy();
        this.getNode();
        this.getPersister();
        this.getSelectBeforeUpdate();
        this.getName_();
        this.getEntityName();
        this.getProxy();
    }
}

