/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateDiscriminatorTag;

public class HibernateDiscriminatorTagImpl
extends XDocletTag
implements HibernateDiscriminatorTag {
    public static final String NAME = "hibernate.discriminator";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("column", "force", "type", "insert", "not-null", "length", "formula", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateDiscriminatorTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getColumn() {
        boolean required = false;
        String result = this.getNamedParameter("column");
        if (required && result == null) {
            this.bomb("column=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getForce() {
        boolean required = false;
        String result = this.getNamedParameter("force");
        if (required && result == null) {
            this.bomb("force=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getType() {
        boolean required = false;
        String result = this.getNamedParameter("type");
        if (required && result == null) {
            this.bomb("type=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Boolean getInsert() {
        boolean required = false;
        String result = this.getNamedParameter("insert");
        if (required && result == null) {
            this.bomb("insert=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public Boolean getNotNull() {
        boolean required = false;
        String result = this.getNamedParameter("not-null");
        if (required && result == null) {
            this.bomb("not-null=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public Integer getLength() {
        boolean required = false;
        String result = this.getNamedParameter("length");
        if (required && result == null) {
            this.bomb("length=\"???\" must be specified.");
        }
        Integer retVal = null;
        if (result != null) {
            try {
                retVal = Integer.decode(result);
            }
            catch (NumberFormatException nfe) {
                this.bomb("length=\"" + result + "\" is not valid integer");
                throw nfe;
            }
        }
        return retVal;
    }

    public String getFormula() {
        boolean required = false;
        String result = this.getNamedParameter("formula");
        if (required && result == null) {
            this.bomb("formula=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnField) {
            this.bomb("is not allowed on fields");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.isOnMethod) {
            this.bomb("is not allowed on methods");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getColumn();
        this.getForce();
        this.getType();
        this.getInsert();
        this.getNotNull();
        this.getLength();
        this.getFormula();
    }
}

