/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.hibernate.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.hibernate.qtags.HibernateIdTag;

public class HibernateIdTagImpl
extends XDocletTag
implements HibernateIdTag {
    public static final String NAME = "hibernate.id";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("generator-class", "type", "unsaved-value", "access", "node", "length", "name", "column", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public HibernateIdTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public String getGeneratorClass() {
        boolean required = true;
        String result = this.getNamedParameter("generator-class");
        if (required && result == null) {
            this.bomb("generator-class=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getType() {
        boolean required = false;
        String result = this.getNamedParameter("type");
        if (required && result == null) {
            this.bomb("type=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getUnsavedValue() {
        boolean required = false;
        String result = this.getNamedParameter("unsaved-value");
        if (required && result == null) {
            this.bomb("unsaved-value=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getAccess() {
        boolean required = false;
        String result = this.getNamedParameter("access");
        if (required && result == null) {
            this.bomb("access=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getNode() {
        boolean required = false;
        String result = this.getNamedParameter("node");
        if (required && result == null) {
            this.bomb("node=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public Integer getLength() {
        boolean required = false;
        String result = this.getNamedParameter("length");
        if (required && result == null) {
            this.bomb("length=\"???\" must be specified.");
        }
        Integer retVal = null;
        if (result != null) {
            try {
                retVal = Integer.decode(result);
            }
            catch (NumberFormatException nfe) {
                this.bomb("length=\"" + result + "\" is not valid integer");
                throw nfe;
            }
        }
        return retVal;
    }

    public String getName_() {
        boolean required = false;
        String result = this.getNamedParameter("name");
        if (required && result == null) {
            this.bomb("name=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getColumn() {
        boolean required = false;
        String result = this.getNamedParameter("column");
        if (required && result == null) {
            this.bomb("column=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnClass) {
            this.bomb("is not allowed on classes");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getGeneratorClass();
        this.getType();
        this.getUnsavedValue();
        this.getAccess();
        this.getNode();
        this.getLength();
        this.getName_();
        this.getColumn();
    }
}

