/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.jdo;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.BeanProperty;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.generama.JellyTemplateEngine;
import org.generama.MetadataProvider;
import org.generama.QDoxCapableMetadataProvider;
import org.generama.TemplateEngine;
import org.generama.WriterMapper;
import org.generama.defaults.QDoxPlugin;
import org.xdoclet.plugin.jdo.JdoProperty;
import org.xdoclet.plugin.jdo.qtags.TagLibrary;

public class JdoPlugin
extends QDoxPlugin {
    private static final List PROPERTY_TAGS = new ArrayList();

    public JdoPlugin(JellyTemplateEngine jellyTemplateEngine, QDoxCapableMetadataProvider metadataProvider, WriterMapper writerMapper) {
        super((TemplateEngine)jellyTemplateEngine, metadataProvider, writerMapper);
        this.setFileregex("\\.java");
        this.setFilereplace("\\.jdo.xml");
        this.setMultioutput(true);
        new TagLibrary((MetadataProvider)metadataProvider);
    }

    public List getClassProperties(JavaClass clazz) {
        ArrayList retval = new ArrayList();
        this.getProperties(clazz, PROPERTY_TAGS, retval);
        return retval;
    }

    public List getPropertyTagList() {
        return PROPERTY_TAGS;
    }

    public boolean shouldGenerate(Object metadata) {
        JavaClass clazz = (JavaClass)metadata;
        return clazz.getTagByName("jdo.class") != null;
    }

    private void getProperties(JavaClass clazz, Collection requierdTags, List accumulate) {
        JdoProperty property;
        BeanProperty[] beanProperties = clazz.getBeanProperties();
        for (int i = 0; i < beanProperties.length; ++i) {
            if (beanProperties[i] == null || beanProperties[i].getAccessor() == null || this.getTags((AbstractJavaEntity)beanProperties[i].getAccessor(), requierdTags).isEmpty()) continue;
            property = new JdoProperty();
            property.setName(beanProperties[i].getName());
            property.setEntity((AbstractJavaEntity)beanProperties[i].getAccessor());
            if (accumulate.contains(property)) continue;
            accumulate.add(property);
        }
        JavaField[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (this.getTags((AbstractJavaEntity)fields[i], requierdTags).isEmpty()) continue;
            property = new JdoProperty();
            property.setName(fields[i].getName());
            property.setEntity((AbstractJavaEntity)fields[i]);
            property.setAccess("field");
            if (accumulate.contains(property)) continue;
            accumulate.add(property);
        }
    }

    private List getTags(AbstractJavaEntity metadata, Collection tagNames) {
        ArrayList<DocletTag> al = new ArrayList<DocletTag>();
        Iterator iter = tagNames.iterator();
        while (iter.hasNext()) {
            al.addAll(Arrays.asList(metadata.getTagsByName((String)iter.next())));
        }
        return al;
    }

    static {
        PROPERTY_TAGS.add("jdo.field");
    }
}

