/*
 * Decompiled with CFR 0.152.
 */
package org.xdoclet.plugin.jdo.qtags;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xdoclet.XDocletTag;
import org.xdoclet.plugin.jdo.qtags.JdoClassTag;

public class JdoClassTagImpl
extends XDocletTag
implements JdoClassTag {
    public static final String NAME = "jdo.class";
    private static final List ALLOWED_PARAMETERS = Arrays.asList("detachable", "embedded-only", "objectid-class", "persistence-modifier", "requires-extent", "table", "identity-type", "");
    private static final List ALLOWED_VALUES = Arrays.asList("");

    public JdoClassTagImpl(String name, String value, AbstractJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public Boolean getDetachable() {
        boolean required = false;
        String result = this.getNamedParameter("detachable");
        if (required && result == null) {
            this.bomb("detachable=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public Boolean getEmbeddedOnly() {
        boolean required = false;
        String result = this.getNamedParameter("embedded-only");
        if (required && result == null) {
            this.bomb("embedded-only=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getObjectidClass() {
        boolean required = false;
        String result = this.getNamedParameter("objectid-class");
        if (required && result == null) {
            this.bomb("objectid-class=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getPersistenceModifier() {
        boolean required = false;
        String result = this.getNamedParameter("persistence-modifier");
        if (required && result == null) {
            this.bomb("persistence-modifier=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            if (!(result.equals("persistence-capable") || result.equals("persistence-aware") || result.equals("non-persistent"))) {
                this.bomb("persistence-modifier=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    public Boolean getRequiresExtent() {
        boolean required = false;
        String result = this.getNamedParameter("requires-extent");
        if (required && result == null) {
            this.bomb("requires-extent=\"???\" must be specified.");
        }
        Boolean retVal = null;
        if (result != null) {
            retVal = Boolean.valueOf(result);
        }
        return retVal;
    }

    public String getTable() {
        boolean required = false;
        String result = this.getNamedParameter("table");
        if (required && result == null) {
            this.bomb("table=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            retVal = result;
        }
        return retVal;
    }

    public String getIdentityType() {
        boolean required = false;
        String result = this.getNamedParameter("identity-type");
        if (required && result == null) {
            this.bomb("identity-type=\"???\" must be specified.");
        }
        String retVal = null;
        if (result != null) {
            if (!(result.equals("application") || result.equals("datastore") || result.equals("nondurable"))) {
                this.bomb("identity-type=\"" + result + "\" is an invalid parameter value.");
            }
            retVal = result;
        }
        return retVal;
    }

    protected void validateLocation() {
        if (this.isOnField) {
            this.bomb("is not allowed on fields");
        }
        if (this.isOnConstructor) {
            this.bomb("is not allowed on constructors");
        }
        if (this.isOnMethod) {
            this.bomb("is not allowed on methods");
        }
        if (this.getContext().getTagsByName(NAME).length > 1) {
            this.bomb("is allowed only once");
        }
        if (ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(this.getValue())) {
            this.bomb("\"" + this.getValue() + "\" is not a valid value. Allowed values are ");
        }
        Set parameterNames = this.getNamedParameterMap().keySet();
        Iterator iterator = parameterNames.iterator();
        while (iterator.hasNext()) {
            String parameterName = (String)iterator.next();
            if (ALLOWED_PARAMETERS.contains(parameterName)) continue;
            this.bomb(parameterName + " is an invalid parameter name.");
        }
        this.getDetachable();
        this.getEmbeddedOnly();
        this.getObjectidClass();
        this.getPersistenceModifier();
        this.getRequiresExtent();
        this.getTable();
        this.getIdentityType();
    }
}

