/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.plexus;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.test.XPathAssert;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.yom.Document;
import org.codehaus.yom.Node;
import org.codehaus.yom.Serializer;
import org.codehaus.yom.stax.StaxBuilder;

public class PlexusXFireTest
extends PlexusTestCase {
    private Map namespaces = new HashMap();

    protected void printNode(Node node) throws Exception {
        Serializer writer = new Serializer((OutputStream)System.out);
        writer.setOutputStream((OutputStream)System.out);
        if (node instanceof Document) {
            writer.write((Document)node);
        } else {
            writer.flush();
            writer.writeChild(node);
        }
    }

    protected Document invokeService(String service, String document) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageContext context = new MessageContext();
        context.setXFire(this.getXFire());
        context.setProperty((Object)"urn:xfire:channel:backchannel", (Object)out);
        if (service != null) {
            context.setService(this.getServiceRegistry().getService(service));
        }
        InputStream stream = this.getResourceAsStream(document);
        InMessage msg = new InMessage(STAXUtils.createXMLStreamReader((InputStream)stream, (String)"UTF-8"));
        Transport t = this.getXFire().getTransportManager().getTransport("urn:xfire:transport:local");
        Channel c = t.createChannel();
        c.receive(context, msg);
        String response = out.toString();
        if (response == null || response.length() == 0) {
            return null;
        }
        return this.readDocument(response);
    }

    protected Document readDocument(String text) throws XMLStreamException {
        try {
            StaxBuilder builder = new StaxBuilder();
            return builder.build((Reader)new StringReader(text));
        }
        catch (XMLStreamException e) {
            System.err.println("Could not read the document!");
            System.out.println(text);
            throw e;
        }
    }

    protected Document getWSDLDocument(String service) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getXFire().generateWSDL(service, (OutputStream)out);
        return this.readDocument(out.toString());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.addNamespace("s", Soap11.getInstance().getNamespace());
        this.addNamespace("soap12", Soap12.getInstance().getNamespace());
    }

    public List assertValid(String xpath, Node node) throws Exception {
        return XPathAssert.assertValid((String)xpath, (Node)node, (Map)this.namespaces);
    }

    public List assertInvalid(String xpath, Node node) throws Exception {
        return XPathAssert.assertInvalid((String)xpath, (Node)node, (Map)this.namespaces);
    }

    public void assertXPathEquals(String xpath, String value, Node node) throws Exception {
        XPathAssert.assertXPathEquals((String)xpath, (String)value, (Node)node, (Map)this.namespaces);
    }

    public void assertNoFault(Node node) throws Exception {
        XPathAssert.assertNoFault((Node)node);
    }

    public void addNamespace(String ns, String uri) {
        this.namespaces.put(ns, uri);
    }

    protected WSDLWriter getWSDL(String service) throws Exception {
        ServiceRegistry reg = this.getServiceRegistry();
        Service hello = reg.getService(service);
        return hello.getWSDLWriter();
    }

    protected XFire getXFire() throws Exception {
        return (XFire)this.lookup(XFire.ROLE);
    }

    protected ServiceRegistry getServiceRegistry() throws Exception {
        return this.getXFire().getServiceRegistry();
    }
}

