/*
 * Decompiled with CFR 0.152.
 */
package au.com.acegi.xmlformat;

import au.com.acegi.xmlformat.LineEnding;
import au.com.acegi.xmlformat.XmlOutputFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.dom4j.DocumentException;

public abstract class AbstractXmlPlugin
extends AbstractMojo {
    @Parameter(property="attributeQuoteChar", defaultValue="\"")
    private char attributeQuoteChar = (char)34;
    @Parameter(defaultValue=".", readonly=true, required=true, property="project.basedir")
    private File baseDirectory;
    @Parameter(property="encoding", defaultValue="UTF-8")
    private String encoding = "UTF-8";
    @Parameter(property="excludes")
    private String[] excludes;
    @Parameter(property="expandEmptyElements", defaultValue="false")
    private boolean expandEmptyElements;
    @Parameter(property="includes")
    private String[] includes;
    @Parameter(property="indentSize", defaultValue="2")
    private int indentSize;
    @Parameter(property="tabIndent", defaultValue="false")
    private boolean tabIndent;
    @Parameter(property="lineEnding", defaultValue="LF")
    private LineEnding lineEnding = LineEnding.LF;
    @Deprecated
    @Parameter(property="lineSeparator", defaultValue="\n")
    private String lineSeparator = "\n";
    @Parameter(property="newLineAfterDeclaration", defaultValue="false")
    private boolean newLineAfterDeclaration;
    @Parameter(property="newLineAfterNTags", defaultValue="0")
    private int newLineAfterNTags;
    @Parameter(property="newlines", defaultValue="true")
    private boolean newlines;
    @Parameter(property="omitEncoding", defaultValue="false")
    private boolean omitEncoding;
    @Parameter(property="padText", defaultValue="false")
    private boolean padText;
    @Parameter(property="xml-format.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="skipTargetFolder", defaultValue="true")
    private boolean skipTargetFolder = true;
    @Parameter(property="suppressDeclaration", defaultValue="false")
    private boolean suppressDeclaration;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File targetDirectory;
    @Parameter(property="trimText", defaultValue="true")
    private boolean trimText;
    @Parameter(property="xhtml", defaultValue="false")
    private boolean xhtml;
    @Parameter(property="keepBlankLines", defaultValue="false")
    private boolean keepBlankLines;

    public void execute() throws MojoExecutionException, MojoFailureException {
        assert (this.baseDirectory != null);
        assert (this.targetDirectory != null);
        if (this.skip) {
            this.getLog().info((CharSequence)"[xml-format] Skipped");
            return;
        }
        this.initializeIncludes();
        this.initializeExcludes();
        XmlOutputFormat fmt = this.buildFormatter();
        boolean success = true;
        boolean neededFormatting = false;
        for (String inputName : this.find()) {
            File input = new File(this.baseDirectory, inputName);
            try {
                neededFormatting |= this.processFile(input, fmt);
            }
            catch (IOException | DocumentException ex) {
                success = false;
                this.getLog().error((CharSequence)("[xml-format] Error for " + input), ex);
            }
        }
        if (!success) {
            throw new MojoFailureException("[xml-format] Failed)");
        }
        this.afterAllProcessed(neededFormatting);
    }

    protected abstract boolean processFile(File var1, XmlOutputFormat var2) throws DocumentException, IOException;

    protected abstract void afterAllProcessed(boolean var1) throws MojoExecutionException;

    void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    void setExcludes(String ... excludes) {
        this.excludes = excludes == null ? null : Arrays.copyOf(excludes, excludes.length);
    }

    void setIncludes(String ... includes) {
        this.includes = includes == null ? null : Arrays.copyOf(includes, includes.length);
    }

    void setSkip(boolean skip) {
        this.skip = skip;
    }

    void setSkipTargetFolder(boolean skipTargetFolder) {
        this.skipTargetFolder = skipTargetFolder;
    }

    void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    private XmlOutputFormat buildFormatter() {
        XmlOutputFormat fmt = new XmlOutputFormat();
        fmt.setAttributeQuoteCharacter(this.attributeQuoteChar);
        fmt.setEncoding(this.encoding);
        fmt.setExpandEmptyElements(this.expandEmptyElements);
        if (this.tabIndent) {
            fmt.setIndent("\t");
        } else {
            fmt.setIndentSize(this.indentSize);
        }
        fmt.setLineSeparator(this.determineLineSeparator());
        fmt.setNewLineAfterDeclaration(this.newLineAfterDeclaration);
        fmt.setNewLineAfterNTags(this.newLineAfterNTags);
        fmt.setNewlines(this.newlines);
        fmt.setOmitEncoding(this.omitEncoding);
        fmt.setPadText(this.padText);
        fmt.setSuppressDeclaration(this.suppressDeclaration);
        fmt.setTrimText(this.trimText);
        fmt.setXHTML(this.xhtml);
        fmt.setKeepBlankLines(this.keepBlankLines);
        return fmt;
    }

    private String determineLineSeparator() {
        return "\n".equals(this.lineSeparator) ? this.lineEnding.getChars() : this.lineSeparator;
    }

    private String[] find() {
        DirectoryScanner dirScanner = new DirectoryScanner();
        dirScanner.setBasedir(this.baseDirectory);
        dirScanner.setIncludes(this.includes);
        ArrayList<String> exclude = new ArrayList<String>(Arrays.asList(this.excludes));
        if (this.skipTargetFolder && this.baseDirectory.equals(this.targetDirectory.getParentFile())) {
            exclude.add(this.targetDirectory.getName() + "/**");
        }
        String[] excluded = new String[exclude.size()];
        dirScanner.setExcludes(exclude.toArray(excluded));
        dirScanner.scan();
        return dirScanner.getIncludedFiles();
    }

    private void initializeExcludes() {
        if (this.excludes == null || this.excludes.length == 0) {
            this.excludes = new String[0];
        }
    }

    private void initializeIncludes() {
        if (this.includes == null || this.includes.length == 0) {
            this.includes = new String[]{"**/*.xml"};
        }
    }
}

