/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.mojo.aws;

import br.com.ingenieux.mojo.aws.Expose;
import br.com.ingenieux.mojo.aws.util.AWSClientFactory;
import br.com.ingenieux.mojo.aws.util.CredentialsUtil;
import br.com.ingenieux.mojo.aws.util.TypeUtil;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class AbstractAWSMojo<S extends AmazonWebServiceClient>
extends AbstractMojo
implements Contextualizable {
    private static final String SECURITY_DISPATCHER_CLASS_NAME = "org.sonatype.plexus.components.sec.dispatcher.SecDispatcher";
    private PlexusContainer container;
    @Parameter(property="settings", required=true, readonly=true)
    protected Settings settings;
    protected AWSCredentials awsCredentials;
    @Parameter(property="beanstalker.serverId", defaultValue="aws.amazon.com")
    protected String serverId;
    @Parameter(property="beanstalker.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="beanstalker.ignoreExceptions", defaultValue="false")
    protected boolean ignoreExceptions;
    protected String version = "?";
    @Parameter(property="beanstalker.region")
    protected String region;
    @Parameter(property="aws.accessKey")
    private String accessKey;
    @Parameter(property="aws.secretKey")
    private String secretKey;
    private S service;
    protected AWSClientFactory clientFactory;

    public AWSCredentials getAWSCredentials() throws MojoFailureException {
        if (null == this.awsCredentials) {
            String awsSecretKey = null;
            String awsAccessKey = null;
            if (this.hasServerSettings()) {
                Expose expose = this.exposeSettings(this.serverId);
                awsAccessKey = expose.getAccessKey();
                awsSecretKey = expose.getSharedKey();
            } else if (StringUtils.isNotBlank((String)this.getAccessKey()) || StringUtils.isNotBlank((String)this.getSecretKey())) {
                this.getLog().warn((CharSequence)"Warning! Usage of accessKey and secretKey is being deprecated! See http://beanstalker.ingenieux.com.br/beanstalk-maven-plugin/security.html for more information");
                awsAccessKey = this.getAccessKey();
                awsSecretKey = this.getDecryptedAwsKey(this.getSecretKey());
            } else {
                String errorMessage = "Entries in settings.xml for server " + this.serverId + " not defined. See http://beanstalker.ingenieux.com.br/beanstalk-maven-plugin/usage.html for more information";
                this.getLog().error((CharSequence)errorMessage);
                throw new MojoFailureException(errorMessage);
            }
            this.awsCredentials = new BasicAWSCredentials(awsAccessKey, awsSecretKey);
        }
        return this.awsCredentials;
    }

    protected Expose exposeSettings(String serverId) {
        Server server = this.settings.getServer(serverId);
        Validate.notNull((Object)server, (String)("Settings for serverId ('" + serverId + "') not found. See http://beanstalker.ingenieux.com.br/beanstalk-maven-plugin/security.html for more information"));
        Expose expose = new Expose();
        expose.setServerId(serverId);
        expose.setAccessKey(server.getUsername());
        expose.setSharedKey(this.getDecryptedAwsKey(server.getPassword().trim()));
        return expose;
    }

    private String getDecryptedAwsKey(String awsSecretKey) {
        if (awsSecretKey.startsWith("{") && awsSecretKey.endsWith("}")) {
            return this.decryptPassword(awsSecretKey);
        }
        this.getLog().warn((CharSequence)"You should encrypt your passwords. See http://beanstalker.ingenieux.com.br/security.html for more information");
        return awsSecretKey;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private boolean hasServerSettings() {
        if (this.serverId == null) {
            return false;
        }
        Server srv = this.settings.getServer(this.serverId);
        return srv != null;
    }

    private String decryptPassword(String password) {
        if (password != null) {
            try {
                Class<?> securityDispatcherClass = this.container.getClass().getClassLoader().loadClass(SECURITY_DISPATCHER_CLASS_NAME);
                Object securityDispatcher = this.container.lookup(SECURITY_DISPATCHER_CLASS_NAME, "maven");
                Method decrypt = securityDispatcherClass.getMethod("decrypt", String.class);
                return (String)decrypt.invoke(securityDispatcher, password);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"security features are disabled. Cannot find plexus security dispatcher", (Throwable)e);
            }
        }
        this.getLog().debug((CharSequence)"password could not be decrypted");
        return password;
    }

    protected ClientConfiguration getClientConfiguration() {
        ClientConfiguration clientConfiguration = new ClientConfiguration().withUserAgent(this.getUserAgent());
        if (null != this.settings && null != this.settings.getActiveProxy()) {
            Proxy proxy = this.settings.getActiveProxy();
            clientConfiguration.setProxyHost(proxy.getHost());
            clientConfiguration.setProxyUsername(proxy.getUsername());
            clientConfiguration.setProxyPassword(proxy.getPassword());
            clientConfiguration.setProxyPort(proxy.getPort());
        }
        return clientConfiguration;
    }

    protected final String getUserAgent() {
        return String.format("Apache Maven/3.0 (ingenieux beanstalker/%s; http://beanstalker.ingenieux.com.br)", this.version);
    }

    protected String getAccessKey() {
        return this.accessKey;
    }

    protected String getSecretKey() {
        return this.secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void setupVersion() {
        InputStream is;
        block4: {
            is = null;
            try {
                Properties properties = new Properties();
                is = ((Object)((Object)this)).getClass().getResourceAsStream("/beanstalker-core.properties");
                if (null == is) break block4;
                properties.load(is);
                this.version = properties.getProperty("beanstalker.version");
            }
            catch (Exception exception) {
                IOUtils.closeQuietly(is);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    protected AbstractAWSMojo() {
        this.setupVersion();
    }

    protected void setupService() throws MojoExecutionException {
        Class<?> serviceClass = TypeUtil.getServiceClass(((Object)((Object)this)).getClass());
        try {
            this.clientFactory = new AWSClientFactory(this.getAWSCredentials(), this.getClientConfiguration(), this.region);
            this.service = (AmazonWebServiceClient)this.clientFactory.getService(serviceClass);
        }
        catch (Exception exc) {
            throw new MojoExecutionException("Unable to create service", exc);
        }
    }

    public S getService() {
        if (null == this.service) {
            try {
                this.setupService();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.service;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        Object result = null;
        try {
            this.configure();
            result = this.executeInternal();
            this.getLog().info((CharSequence)"SUCCESS");
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"FAILURE", (Throwable)e);
            this.handleException(e);
            return;
        }
        this.displayResults(result, 0);
    }

    protected void configure() {
    }

    public void handleException(Exception e) throws MojoExecutionException, MojoFailureException {
        if (this.ignoreExceptions) {
            this.getLog().warn((CharSequence)"Ok. ignoreExceptions is set to true. No result for you!");
            return;
        }
        if (MojoExecutionException.class.isAssignableFrom(e.getClass())) {
            throw (MojoExecutionException)e;
        }
        if (MojoFailureException.class.isAssignableFrom(e.getClass())) {
            throw (MojoFailureException)e;
        }
        throw new MojoFailureException("Failed", (Throwable)e);
    }

    protected void displayResults(Object result, int level) {
        if (null == result) {
            return;
        }
        String prefix = StringUtils.repeat((String)" ", (int)(level * 2)) + " * ";
        if (Collection.class.isAssignableFrom(result.getClass())) {
            Collection coll = (Collection)Collection.class.cast(result);
            for (Object o : coll) {
                this.displayResults(o, 1 + level);
            }
            return;
        }
        if ("java.lang".equals(result.getClass().getPackage().getName())) {
            this.getLog().info((CharSequence)(prefix + CredentialsUtil.redact("" + result) + " [class: " + result.getClass().getSimpleName() + "]"));
            return;
        }
        BeanMap beanMap = new BeanMap(result);
        Iterator itProperty = beanMap.keyIterator();
        while (itProperty.hasNext()) {
            String propertyName = "" + itProperty.next();
            Object propertyValue = beanMap.get((Object)propertyName);
            if ("class".equals(propertyName) || null == propertyValue) continue;
            Class propertyClass = null;
            try {
                propertyClass = beanMap.getType(propertyName);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failure on property " + propertyName), (Throwable)e);
            }
            if (null == propertyClass) {
                this.getLog().info((CharSequence)(prefix + propertyName + ": " + CredentialsUtil.redact("" + propertyValue)));
                continue;
            }
            this.getLog().info((CharSequence)(prefix + propertyName + ": " + CredentialsUtil.redact("" + propertyValue) + " [class: " + propertyClass.getSimpleName() + "]"));
        }
    }

    protected abstract Object executeInternal() throws Exception;

    public boolean isVerbose() {
        return this.verbose;
    }
}

